/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate.javadsl;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.generate.XsdTestGenerator;
import com.consol.citrus.generate.dictionary.InboundXmlDataDictionary;
import com.consol.citrus.generate.dictionary.OutboundXmlDataDictionary;
import com.consol.citrus.generate.javadsl.MessagingJavaTestGenerator;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.xml.XmlConfigurer;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xsd2inst.SampleXmlUtil;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class XsdJavaTestGenerator
extends MessagingJavaTestGenerator<XsdJavaTestGenerator>
implements XsdTestGenerator<XsdJavaTestGenerator> {
    private String xsd;
    private String requestMessage;
    private String responseMessage;
    private String nameSuffix = "IT";
    private InboundXmlDataDictionary inboundDataDictionary = new InboundXmlDataDictionary();
    private OutboundXmlDataDictionary outboundDataDictionary = new OutboundXmlDataDictionary();

    @Override
    public void create() {
        SchemaTypeSystem schemaTypeSystem = this.compileXsd(this.xsd);
        SchemaType[] globalElems = schemaTypeSystem.documentTypes();
        SchemaType requestElem = null;
        SchemaType responseElem = null;
        if (!StringUtils.hasText((String)this.getName())) {
            this.withName(this.getTestNameSuggestion());
        }
        if (!StringUtils.hasText((String)this.responseMessage)) {
            this.responseMessage = this.getResponseMessageSuggestion();
        }
        for (SchemaType elem : globalElems) {
            if (!elem.getContentModel().getName().getLocalPart().equals(this.requestMessage)) continue;
            requestElem = elem;
            break;
        }
        for (SchemaType elem : globalElems) {
            if (!elem.getContentModel().getName().getLocalPart().equals(this.responseMessage)) continue;
            responseElem = elem;
            break;
        }
        if (requestElem == null) {
            throw new CitrusRuntimeException(String.format("Unable to find element with name '%s' in XSD %s", this.requestMessage, this.xsd));
        }
        this.withRequest((Message)new DefaultMessage((Object)SampleXmlUtil.createSampleForType((SchemaType)requestElem)));
        if (responseElem != null) {
            this.withResponse((Message)new DefaultMessage((Object)SampleXmlUtil.createSampleForType((SchemaType)responseElem)));
        } else {
            this.withResponse(null);
        }
        XmlConfigurer configurer = new XmlConfigurer();
        configurer.setSerializeSettings(Collections.singletonMap("xml-declaration", false));
        XMLUtils.initialize((XmlConfigurer)configurer);
        super.create();
    }

    @Override
    protected Message generateInboundMessage(Message message) {
        return this.inboundDataDictionary.interceptMessageConstruction(message, MessageType.XML.name(), new TestContext());
    }

    @Override
    protected Message generateOutboundMessage(Message message) {
        return this.outboundDataDictionary.interceptMessageConstruction(message, MessageType.XML.name(), new TestContext());
    }

    @Override
    public String getResponseMessageSuggestion() {
        String suggestion = this.requestMessage.endsWith("Req") ? this.requestMessage.substring(0, this.requestMessage.indexOf("Req")) + "Res" : (this.requestMessage.endsWith("Request") ? this.requestMessage.substring(0, this.requestMessage.indexOf("Request")) + "Response" : (this.requestMessage.endsWith("RequestMessage") ? this.requestMessage.substring(0, this.requestMessage.indexOf("RequestMessage")) + "ResponseMessage" : ""));
        return suggestion;
    }

    public String getTestNameSuggestion() {
        String suggestion = this.requestMessage.endsWith("Req") ? this.requestMessage.substring(0, this.requestMessage.indexOf("Req")) + this.nameSuffix : (this.requestMessage.endsWith("Request") ? this.requestMessage.substring(0, this.requestMessage.indexOf("Request")) + this.nameSuffix : (this.requestMessage.endsWith("RequestMessage") ? this.requestMessage.substring(0, this.requestMessage.indexOf("RequestMessage")) + this.nameSuffix : this.requestMessage + this.nameSuffix));
        return suggestion;
    }

    private SchemaTypeSystem compileXsd(String xsd) {
        XmlObject xsdObject;
        File xsdFile;
        try {
            xsdFile = new PathMatchingResourcePatternResolver().getResource(xsd).getFile();
        }
        catch (IOException e) {
            xsdFile = new File(xsd);
        }
        if (!xsdFile.exists()) {
            throw new CitrusRuntimeException("Unable to read XSD - does not exist in " + xsdFile.getAbsolutePath());
        }
        if (!xsdFile.canRead()) {
            throw new CitrusRuntimeException("Unable to read XSD - could not open in read mode");
        }
        try {
            xsdObject = XmlObject.Factory.parse((File)xsdFile, (XmlOptions)new XmlOptions().setLoadLineNumbers().setLoadMessageDigest().setCompileDownloadUrls());
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to parse XSD schema", (Throwable)e);
        }
        XmlObject[] schemas = new XmlObject[]{xsdObject};
        try {
            return XmlBeans.compileXsd((XmlObject[])schemas, (SchemaTypeLoader)XmlBeans.getContextTypeLoader(), (XmlOptions)new XmlOptions());
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to compile XSD schema", (Throwable)e);
        }
    }

    @Override
    public XsdJavaTestGenerator withXsd(String xsdResource) {
        this.xsd = xsdResource;
        return this;
    }

    @Override
    public XsdJavaTestGenerator withRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
        return this;
    }

    @Override
    public XsdJavaTestGenerator withResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
        return this;
    }

    @Override
    public XsdJavaTestGenerator withNameSuffix(String suffix) {
        this.nameSuffix = suffix;
        return this;
    }

    @Override
    public XsdJavaTestGenerator withInboundMappings(Map<String, String> mappings) {
        this.inboundDataDictionary.getMappings().putAll(mappings);
        return this;
    }

    @Override
    public XsdJavaTestGenerator withOutboundMappings(Map<String, String> mappings) {
        this.outboundDataDictionary.getMappings().putAll(mappings);
        return this;
    }

    @Override
    public XsdJavaTestGenerator withInboundMappingFile(String mappingFile) {
        this.inboundDataDictionary.setMappingFile(new PathMatchingResourcePatternResolver().getResource(mappingFile));
        try {
            this.inboundDataDictionary.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to read mapping file", (Throwable)e);
        }
        return this;
    }

    @Override
    public XsdJavaTestGenerator withOutboundMappingFile(String mappingFile) {
        this.outboundDataDictionary.setMappingFile(new PathMatchingResourcePatternResolver().getResource(mappingFile));
        try {
            this.outboundDataDictionary.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to read mapping file", (Throwable)e);
        }
        return this;
    }

    public void setXsd(String xsd) {
        this.xsd = xsd;
    }

    @Override
    public String getXsd() {
        return this.xsd;
    }

    public void setRequestMessage(String requestMessage) {
        this.requestMessage = requestMessage;
    }

    @Override
    public String getRequestMessage() {
        return this.requestMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    @Override
    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    public String getNameSuffix() {
        return this.nameSuffix;
    }
}

