/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate.provider.http;

import com.consol.citrus.generate.provider.CodeProvider;
import com.consol.citrus.http.message.HttpMessage;
import com.squareup.javapoet.CodeBlock;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;

public class SendHttpResponseCodeProvider
implements CodeProvider<HttpMessage> {
    @Override
    public CodeBlock getCode(String endpoint, HttpMessage message) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("http(action -> action.server($S)\n", new Object[]{endpoint});
        code.indent();
        code.add(".send()\n", new Object[0]);
        code.add(".response($T.$L)\n", new Object[]{HttpStatus.class, message.getStatusCode().name()});
        if (StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            code.add(".payload($S)\n", new Object[]{message.getPayload(String.class)});
        }
        message.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("citrus_")).forEach(entry -> code.add(".header($S, $S)\n", new Object[]{entry.getKey(), Optional.ofNullable(entry.getValue()).map(Object::toString).orElse("")}));
        code.unindent();
        code.add(");", new Object[0]);
        return code.build();
    }
}

