/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate;

import com.consol.citrus.Citrus;
import com.consol.citrus.generate.TestGenerator;
import com.consol.citrus.generate.UnitFramework;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestGenerator<T extends TestGenerator>
implements TestGenerator<T> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String name;
    private String author;
    private String description;
    private String targetPackage;
    private String srcDirectory = Citrus.DEFAULT_TEST_SRC_DIRECTORY;
    private UnitFramework framework;
    private String fileExtension;
    private boolean disabled = false;
    protected T self = this;

    @Override
    public T withName(String name) {
        this.name = name;
        return this.self;
    }

    @Override
    public T withAuthor(String author) {
        this.author = author;
        return this.self;
    }

    @Override
    public T withDescription(String description) {
        this.description = description;
        return this.self;
    }

    public T withFileExtension(String extension) {
        this.fileExtension = extension;
        return this.self;
    }

    @Override
    public T usePackage(String targetPackage) {
        this.targetPackage = targetPackage;
        return this.self;
    }

    @Override
    public T useSrcDirectory(String srcDirectory) {
        this.srcDirectory = srcDirectory;
        return this.self;
    }

    @Override
    public T withFramework(UnitFramework framework) {
        this.framework = framework;
        return this.self;
    }

    @Override
    public T withDisabled(boolean disabled) {
        this.disabled = disabled;
        return this.self;
    }

    protected String getMethodName() {
        return this.getName().substring(0, 1).toLowerCase() + this.getName().substring(1);
    }

    protected String getCreationDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(GregorianCalendar.getInstance().getTime());
    }

    protected String getUpdateDateTime() {
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(GregorianCalendar.getInstance().getTime());
    }

    protected File getTargetFile() {
        return new File(this.getSrcDirectory() + File.separator + this.getTargetPackage().replace('.', File.separatorChar) + File.separator + this.getName() + this.getFileExtension());
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public String getSrcDirectory() {
        return this.srcDirectory;
    }

    public void setSrcDirectory(String srcDirectory) {
        this.srcDirectory = srcDirectory;
    }

    public String getPackage() {
        return this.targetPackage;
    }

    @Override
    public String getTargetPackage() {
        return this.targetPackage;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    @Override
    public UnitFramework getFramework() {
        return this.framework;
    }

    public void setFramework(UnitFramework framework) {
        this.framework = framework;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }
}

