/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate.provider;

import com.consol.citrus.generate.provider.CodeProvider;
import com.consol.citrus.message.Message;
import com.squareup.javapoet.CodeBlock;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

public class ReceiveCodeProvider
implements CodeProvider<Message> {
    @Override
    public CodeBlock getCode(String endpoint, Message message) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("receive(action -> action.endpoint($S)\n", new Object[]{endpoint});
        code.indent();
        code.add(".payload($S)\n", new Object[]{message.getPayload(String.class)});
        if (!CollectionUtils.isEmpty((Map)message.getHeaders())) {
            message.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("citrus_")).forEach(entry -> code.add(".header($S, $S)\n", new Object[]{entry.getKey(), Optional.ofNullable(entry.getValue()).map(Object::toString).orElse("")}));
        }
        code.unindent();
        code.add(");", new Object[0]);
        return code.build();
    }
}

