/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate.provider.http;

import com.consol.citrus.generate.provider.CodeProvider;
import com.consol.citrus.http.message.HttpMessage;
import com.squareup.javapoet.CodeBlock;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class ReceiveHttpRequestCodeProvider
implements CodeProvider<HttpMessage> {
    @Override
    public CodeBlock getCode(String endpoint, HttpMessage message) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("http(action -> action.server($S)\n", new Object[]{endpoint});
        code.indent();
        code.add(".receive()\n", new Object[0]);
        String method = Optional.ofNullable(message.getRequestMethod()).map(Object::toString).orElse(RequestMethod.POST.name());
        code.add(".$L($L)\n", new Object[]{method.toLowerCase(), Optional.ofNullable(message.getPath()).map(Object::toString).map(path -> "\"" + path + "\"").orElse("")});
        code.add(".contentType($S)\n", new Object[]{Optional.ofNullable(message.getHeader("Content-Type")).orElse("application/json")});
        if (StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            code.add(".payload($S)\n", new Object[]{message.getPayload(String.class)});
        }
        message.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("citrus_")).forEach(entry -> code.add(".header($S, $S)\n", new Object[]{entry.getKey(), Optional.ofNullable(entry.getValue()).map(Object::toString).orElse("")}));
        if (!CollectionUtils.isEmpty((Map)message.getQueryParams())) {
            message.getQueryParams().forEach((key, value) -> code.add(".queryParam($S, $S)\n", new Object[]{key, value}));
        } else if (StringUtils.hasText((String)message.getQueryParamString())) {
            Stream.of(message.getQueryParamString().split(",")).map(nameValuePair -> nameValuePair.split("=")).forEach(param -> code.add(".queryParam($S, $S)\n", new Object[]{param[0], param[1]}));
        }
        code.unindent();
        code.add(");", new Object[0]);
        return code.build();
    }
}

