/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate.xml;

import com.consol.citrus.generate.TestGenerator;
import com.consol.citrus.generate.provider.MessageActionProvider;
import com.consol.citrus.generate.provider.ReceiveActionProvider;
import com.consol.citrus.generate.provider.SendActionProvider;
import com.consol.citrus.generate.provider.http.ReceiveHttpRequestActionProvider;
import com.consol.citrus.generate.provider.http.ReceiveHttpResponseActionProvider;
import com.consol.citrus.generate.provider.http.SendHttpRequestActionProvider;
import com.consol.citrus.generate.provider.http.SendHttpResponseActionProvider;
import com.consol.citrus.generate.provider.soap.ReceiveSoapRequestActionProvider;
import com.consol.citrus.generate.provider.soap.ReceiveSoapResponseActionProvider;
import com.consol.citrus.generate.provider.soap.SendSoapRequestActionProvider;
import com.consol.citrus.generate.provider.soap.SendSoapResponseActionProvider;
import com.consol.citrus.generate.xml.XmlTestGenerator;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.message.Message;
import com.consol.citrus.ws.message.SoapMessage;
import java.util.List;
import java.util.Optional;

public class MessagingXmlTestGenerator<T extends MessagingXmlTestGenerator>
extends XmlTestGenerator<T> {
    private String endpoint;
    private Message request;
    private Message response;

    @Override
    protected List<Object> getActions() {
        List<Object> actions = super.getActions();
        if (this.getMode().equals((Object)TestGenerator.GeneratorMode.CLIENT)) {
            actions.add(this.getSendRequestActionProvider(this.request).getAction(Optional.ofNullable(this.endpoint).orElse(this.getMode().name().toLowerCase()), this.generateOutboundMessage(this.request)));
            if (this.response != null) {
                actions.add(this.getReceiveResponseActionProvider(this.response).getAction(Optional.ofNullable(this.endpoint).orElse(this.getMode().name().toLowerCase()), this.generateInboundMessage(this.response)));
            }
        } else if (this.getMode().equals((Object)TestGenerator.GeneratorMode.SERVER)) {
            actions.add(this.getReceiveRequestActionProvider(this.request).getAction(Optional.ofNullable(this.endpoint).orElse(this.getMode().name().toLowerCase()), this.generateInboundMessage(this.request)));
            if (this.response != null) {
                actions.add(this.getSendResponseActionProvider(this.response).getAction(Optional.ofNullable(this.endpoint).orElse(this.getMode().name().toLowerCase()), this.generateOutboundMessage(this.response)));
            }
        }
        return actions;
    }

    protected Message generateInboundMessage(Message message) {
        return message;
    }

    protected Message generateOutboundMessage(Message message) {
        return message;
    }

    protected <T, M extends Message> MessageActionProvider<T, M> getSendRequestActionProvider(M message) {
        if (message instanceof HttpMessage) {
            return new SendHttpRequestActionProvider();
        }
        if (message instanceof SoapMessage) {
            return new SendSoapRequestActionProvider();
        }
        return new SendActionProvider();
    }

    protected <T, M extends Message> MessageActionProvider<T, M> getReceiveResponseActionProvider(M message) {
        if (message instanceof HttpMessage) {
            return new ReceiveHttpResponseActionProvider();
        }
        if (message instanceof SoapMessage) {
            return new ReceiveSoapResponseActionProvider();
        }
        return new ReceiveActionProvider();
    }

    protected <T, M extends Message> MessageActionProvider<T, M> getSendResponseActionProvider(M message) {
        if (message instanceof HttpMessage) {
            return new SendHttpResponseActionProvider();
        }
        if (message instanceof SoapMessage) {
            return new SendSoapResponseActionProvider();
        }
        return new SendActionProvider();
    }

    protected <T, M extends Message> MessageActionProvider<T, M> getReceiveRequestActionProvider(M message) {
        if (message instanceof HttpMessage) {
            return new ReceiveHttpRequestActionProvider();
        }
        if (message instanceof SoapMessage) {
            return new ReceiveSoapRequestActionProvider();
        }
        return new ReceiveActionProvider();
    }

    public T withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return (T)((MessagingXmlTestGenerator)this.self);
    }

    public T withRequest(Message request) {
        this.request = request;
        return (T)((MessagingXmlTestGenerator)this.self);
    }

    public T withResponse(Message response) {
        this.response = response;
        return (T)((MessagingXmlTestGenerator)this.self);
    }

    public T addRequestHeader(String name, Object value) {
        this.request.setHeader(name, value);
        return (T)((MessagingXmlTestGenerator)this.self);
    }

    public T addResponseHeader(String name, Object value) {
        this.request.setHeader(name, value);
        return (T)((MessagingXmlTestGenerator)this.self);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }
}

