/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate.xml;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.generate.WsdlTestGenerator;
import com.consol.citrus.generate.dictionary.InboundXmlDataDictionary;
import com.consol.citrus.generate.dictionary.OutboundXmlDataDictionary;
import com.consol.citrus.generate.xml.MessagingXmlTestGenerator;
import com.consol.citrus.message.Message;
import com.consol.citrus.model.testcase.ws.ObjectFactory;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.ws.message.SoapMessage;
import com.consol.citrus.xml.XmlConfigurer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.xsd2inst.SampleXmlUtil;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

public class WsdlXmlTestGenerator
extends MessagingXmlTestGenerator<WsdlXmlTestGenerator>
implements WsdlTestGenerator<WsdlXmlTestGenerator> {
    private String wsdl;
    private String operation;
    private String namePrefix;
    private String nameSuffix = "_IT";
    private InboundXmlDataDictionary inboundDataDictionary = new InboundXmlDataDictionary();
    private OutboundXmlDataDictionary outboundDataDictionary = new OutboundXmlDataDictionary();

    @Override
    public void create() {
        XmlObject[] operations;
        String wsdlNsDelaration = "declare namespace wsdl='http://schemas.xmlsoap.org/wsdl/' ";
        String soapNsDelaration = "declare namespace soap='http://schemas.xmlsoap.org/wsdl/soap/' ";
        XmlObject wsdlObject = this.compileWsdl(this.wsdl);
        SchemaTypeSystem schemaTypeSystem = this.compileXsd(wsdlObject);
        this.log.info("WSDL compilation successful");
        String serviceName = this.evaluateAsString(wsdlObject, wsdlNsDelaration + ".//wsdl:portType/@name");
        this.log.info("Found service: " + serviceName);
        if (!StringUtils.hasText((String)this.namePrefix)) {
            this.withNamePrefix(serviceName + "_");
        }
        this.log.info("Found service operations:");
        XmlObject[] messages = wsdlObject.selectPath(wsdlNsDelaration + ".//wsdl:message");
        for (XmlObject operation : operations = wsdlObject.selectPath(wsdlNsDelaration + ".//wsdl:portType/wsdl:operation")) {
            this.log.info(this.evaluateAsString(operation, wsdlNsDelaration + "./@name"));
        }
        this.log.info("Generating test cases for service operations ...");
        for (XmlObject operation : operations) {
            XmlObject[] bindingOperations;
            SoapMessage request = new SoapMessage();
            SoapMessage response = new SoapMessage();
            String operationName = this.evaluateAsString(operation, wsdlNsDelaration + "./@name");
            if (StringUtils.hasText((String)this.operation) && !operationName.equals(this.operation)) continue;
            for (XmlObject bindingOperation : bindingOperations = wsdlObject.selectPath(wsdlNsDelaration + ".//wsdl:binding/wsdl:operation")) {
                XmlObject[] bindingOperationName = this.evaluateAsString(bindingOperation, wsdlNsDelaration + "./@name");
                if (!bindingOperationName.equals(operationName)) continue;
                String soapAction = this.removeNsPrefix(this.evaluateAsString(bindingOperation, soapNsDelaration + "./soap:operation/@soapAction"));
                request.soapAction(soapAction);
                break;
            }
            String inputMessage = this.removeNsPrefix(this.evaluateAsString(operation, wsdlNsDelaration + "./wsdl:input/@message"));
            String outputMessage = this.removeNsPrefix(this.evaluateAsString(operation, wsdlNsDelaration + "./wsdl:output/@message"));
            String inputElement = null;
            String outputElement = null;
            for (XmlObject message : messages) {
                String messageName = this.evaluateAsString(message, wsdlNsDelaration + "./@name");
                if (messageName.equals(inputMessage)) {
                    inputElement = this.removeNsPrefix(this.evaluateAsString(message, wsdlNsDelaration + "./wsdl:part/@element"));
                }
                if (!messageName.equals(outputMessage)) continue;
                outputElement = this.removeNsPrefix(this.evaluateAsString(message, wsdlNsDelaration + "./wsdl:part/@element"));
            }
            this.withName(this.namePrefix + operationName + this.nameSuffix);
            SchemaType requestElem = this.getSchemaType(schemaTypeSystem, operationName, inputElement);
            request.setPayload((Object)SampleXmlUtil.createSampleForType((SchemaType)requestElem));
            this.withRequest((Message)request);
            SchemaType responseElem = this.getSchemaType(schemaTypeSystem, operationName, outputElement);
            response.setPayload((Object)SampleXmlUtil.createSampleForType((SchemaType)responseElem));
            this.withResponse((Message)response);
            XmlConfigurer configurer = new XmlConfigurer();
            configurer.initialize();
            configurer.setSerializeSettings(Collections.singletonMap("xml-declaration", false));
            XMLUtils.initialize((XmlConfigurer)configurer);
            super.create();
            this.log.info("Successfully created new test case " + this.getTargetPackage() + "." + this.getName());
        }
    }

    @Override
    protected List<String> getMarshallerContextPaths() {
        List<String> contextPaths = super.getMarshallerContextPaths();
        contextPaths.add(ObjectFactory.class.getPackage().getName());
        return contextPaths;
    }

    @Override
    protected Message generateInboundMessage(Message message) {
        this.inboundDataDictionary.process(message, new TestContext());
        return super.generateInboundMessage(message);
    }

    @Override
    protected Message generateOutboundMessage(Message message) {
        this.outboundDataDictionary.process(message, new TestContext());
        return super.generateOutboundMessage(message);
    }

    private XmlObject compileWsdl(String wsdl) {
        File wsdlFile;
        try {
            wsdlFile = new PathMatchingResourcePatternResolver().getResource(wsdl).getFile();
        }
        catch (IOException e) {
            wsdlFile = new File(wsdl);
        }
        if (!wsdlFile.exists()) {
            throw new CitrusRuntimeException("Unable to read WSDL - does not exist in " + wsdlFile.getAbsolutePath());
        }
        if (!wsdlFile.canRead()) {
            throw new CitrusRuntimeException("Unable to read WSDL - could not open in read mode");
        }
        try {
            return XmlObject.Factory.parse((File)wsdlFile, (XmlOptions)new XmlOptions().setLoadLineNumbers().setLoadMessageDigest().setCompileDownloadUrls());
        }
        catch (XmlException e) {
            for (Object error : e.getErrors()) {
                this.log.error(((XmlError)error).getLine() + error.toString());
            }
            throw new CitrusRuntimeException("WSDL could not be parsed", (Throwable)e);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("WSDL could not be parsed", (Throwable)e);
        }
    }

    private SchemaTypeSystem compileXsd(XmlObject wsdl) {
        String[] namespacesWsdl = this.extractNamespacesOnWsdlLevel(wsdl);
        String schemaNsPrefix = this.extractSchemaNamespacePrefix(wsdl);
        String[] schemas = this.getNestedSchemas(wsdl, namespacesWsdl, schemaNsPrefix);
        XmlObject[] xsd = new XmlObject[schemas.length];
        try {
            for (int i = 0; i < schemas.length; ++i) {
                xsd[i] = XmlObject.Factory.parse((String)schemas[i], (XmlOptions)new XmlOptions().setLoadLineNumbers().setLoadMessageDigest().setCompileDownloadUrls());
            }
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to parse XSD schema", (Throwable)e);
        }
        SchemaTypeSystem schemaTypeSystem = null;
        try {
            schemaTypeSystem = XmlBeans.compileXsd((XmlObject[])xsd, (SchemaTypeLoader)XmlBeans.getContextTypeLoader(), (XmlOptions)new XmlOptions());
        }
        catch (XmlException e) {
            for (Object error : e.getErrors()) {
                this.log.error("Line " + ((XmlError)error).getLine() + ": " + error.toString());
            }
            throw new CitrusRuntimeException("Failed to compile XSD schema", (Throwable)e);
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to compile XSD schema", (Throwable)e);
        }
        return schemaTypeSystem;
    }

    private SchemaType getSchemaType(SchemaTypeSystem schemaTypeSystem, String operation, String elementName) {
        for (SchemaType elem : schemaTypeSystem.documentTypes()) {
            if (!elem.getContentModel().getName().getLocalPart().equals(elementName)) continue;
            return elem;
        }
        throw new CitrusRuntimeException("Unable to find schema type declaration '" + elementName + "' for WSDL operation '" + operation + "'");
    }

    private String removeNsPrefix(String elementName) {
        return elementName.indexOf(58) != -1 ? elementName.substring(elementName.indexOf(58) + 1) : elementName;
    }

    private String[] getNestedSchemas(XmlObject wsdl, String[] namespacesWsdl, String schemaNsPrefix) {
        ArrayList<String> schemas = new ArrayList<String>();
        String openedStartTag = "<" + schemaNsPrefix + "schema";
        String endTag = "</" + schemaNsPrefix + "schema>";
        int cursor = 0;
        while (wsdl.xmlText().indexOf(openedStartTag, cursor) != -1) {
            int begin = wsdl.xmlText().indexOf(openedStartTag, cursor);
            int end = wsdl.xmlText().indexOf(endTag, begin) + endTag.length();
            int insertPointNamespacesWsdl = wsdl.xmlText().indexOf(" ", begin);
            StringBuilder builder = new StringBuilder();
            builder.append(wsdl.xmlText().substring(begin, insertPointNamespacesWsdl)).append(" ");
            for (String nsWsdl : namespacesWsdl) {
                String nsPrefix = nsWsdl.substring(0, nsWsdl.indexOf("="));
                if (wsdl.xmlText().substring(begin, end).contains(nsPrefix)) continue;
                builder.append(nsWsdl).append(" ");
            }
            builder.append(wsdl.xmlText().substring(insertPointNamespacesWsdl, end));
            schemas.add(builder.toString());
            cursor = end;
        }
        return schemas.toArray(new String[0]);
    }

    private String extractSchemaNamespacePrefix(XmlObject wsdl) {
        String schemaNsPrefix = "";
        if (wsdl.xmlText().contains(":schema")) {
            int cursor;
            for (int i = cursor = wsdl.xmlText().indexOf(":schema"); i > cursor - 100; --i) {
                schemaNsPrefix = wsdl.xmlText().substring(i, cursor);
                if (!schemaNsPrefix.startsWith("<")) continue;
                return schemaNsPrefix.substring(1) + ":";
            }
        }
        return schemaNsPrefix;
    }

    private String[] extractNamespacesOnWsdlLevel(XmlObject wsdl) {
        int cursor = wsdl.xmlText().indexOf(":") + ":definitions ".length();
        String nsWsdlOrig = wsdl.xmlText().substring(cursor, wsdl.xmlText().indexOf(">", cursor));
        int noNs = StringUtils.countOccurrencesOf((String)nsWsdlOrig, (String)"xmlns:");
        String[] namespacesWsdl = new String[noNs];
        cursor = 0;
        for (int i = 0; i < noNs; ++i) {
            int begin = nsWsdlOrig.indexOf("xmlns:", cursor);
            int end = nsWsdlOrig.indexOf("\"", begin + 20);
            namespacesWsdl[i] = nsWsdlOrig.substring(begin, end) + "\"";
            cursor = end;
        }
        return namespacesWsdl;
    }

    private String evaluateAsString(XmlObject rootObject, String pathToAttribute) {
        XmlObject[] xmlObject = rootObject.selectPath(pathToAttribute);
        if (xmlObject.length == 0) {
            throw new CitrusRuntimeException("Unable to find element attribute " + pathToAttribute);
        }
        int begin = xmlObject[0].xmlText().indexOf(">") + 1;
        int end = xmlObject[0].xmlText().lastIndexOf("</");
        return xmlObject[0].xmlText().substring(begin, end);
    }

    @Override
    public WsdlXmlTestGenerator withWsdl(String wsdlResource) {
        this.wsdl = wsdlResource;
        return this;
    }

    @Override
    public WsdlXmlTestGenerator withNameSuffix(String suffix) {
        this.nameSuffix = suffix;
        return this;
    }

    @Override
    public WsdlXmlTestGenerator withNamePrefix(String prefix) {
        this.namePrefix = prefix;
        return this;
    }

    @Override
    public WsdlXmlTestGenerator withOperation(String operation) {
        this.operation = operation;
        return this;
    }

    @Override
    public WsdlXmlTestGenerator withInboundMappings(Map<String, String> mappings) {
        this.inboundDataDictionary.getMappings().putAll(mappings);
        return this;
    }

    @Override
    public WsdlXmlTestGenerator withOutboundMappings(Map<String, String> mappings) {
        this.outboundDataDictionary.getMappings().putAll(mappings);
        return this;
    }

    @Override
    public WsdlXmlTestGenerator withInboundMappingFile(String mappingFile) {
        this.inboundDataDictionary.setMappingFile(new PathMatchingResourcePatternResolver().getResource(mappingFile));
        this.inboundDataDictionary.initialize();
        return this;
    }

    @Override
    public WsdlXmlTestGenerator withOutboundMappingFile(String mappingFile) {
        this.outboundDataDictionary.setMappingFile(new PathMatchingResourcePatternResolver().getResource(mappingFile));
        this.outboundDataDictionary.initialize();
        return this;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    @Override
    public String getWsdl() {
        return this.wsdl;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }

    @Override
    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }
}

