/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate.xml;

import com.consol.citrus.generate.AbstractTemplateBasedTestGenerator;
import com.consol.citrus.generate.TestGenerator;
import com.consol.citrus.generate.javadsl.JavaTestGenerator;
import com.consol.citrus.model.testcase.core.EchoModel;
import com.consol.citrus.model.testcase.core.ObjectFactory;
import com.consol.citrus.xml.StringResult;
import com.consol.citrus.xml.namespace.CitrusNamespacePrefixMapper;
import com.sun.xml.bind.marshaller.NamespacePrefixMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.xml.transform.Result;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

public class XmlTestGenerator<T extends XmlTestGenerator>
extends AbstractTemplateBasedTestGenerator<T> {
    private TestGenerator.GeneratorMode mode = TestGenerator.GeneratorMode.CLIENT;
    private Jaxb2Marshaller marshaller = new Jaxb2Marshaller();
    private NamespacePrefixMapper namespacePrefixMapper = new CitrusNamespacePrefixMapper();

    public XmlTestGenerator() {
        this.withFileExtension(".xml");
        this.marshaller.setSchema((Resource)new ClassPathResource("com/consol/citrus/schema/citrus-testcase.xsd"));
        List<String> contextPaths = this.getMarshallerContextPaths();
        this.marshaller.setContextPaths(contextPaths.toArray(new String[contextPaths.size()]));
        HashMap<String, Object> marshallerProperties = new HashMap<String, Object>();
        marshallerProperties.put("jaxb.formatted.output", true);
        marshallerProperties.put("jaxb.encoding", "UTF-8");
        marshallerProperties.put("jaxb.fragment", true);
        marshallerProperties.put("com.sun.xml.bind.namespacePrefixMapper", this.namespacePrefixMapper);
        this.marshaller.setMarshallerProperties(marshallerProperties);
    }

    @Override
    public T withMode(TestGenerator.GeneratorMode mode) {
        this.mode = mode;
        return (T)((XmlTestGenerator)this.self);
    }

    protected List<String> getMarshallerContextPaths() {
        ArrayList<String> contextPaths = new ArrayList<String>();
        contextPaths.add(ObjectFactory.class.getPackage().getName());
        return contextPaths;
    }

    @Override
    public void create() {
        super.create();
        this.getJavaTestGenerator().create();
    }

    @Override
    protected Properties getTemplateProperties() {
        Properties properties = super.getTemplateProperties();
        properties.put("test.actions", this.getActions().stream().map(action -> {
            StringResult result = new StringResult();
            this.marshaller.marshal(action, (Result)result);
            return Pattern.compile("^", 8).matcher(result.toString()).replaceAll("        ");
        }).collect(Collectors.joining("\n\n")));
        return properties;
    }

    protected List<Object> getActions() {
        ArrayList<Object> actions = new ArrayList<Object>();
        EchoModel echo = new EchoModel();
        echo.setMessage("TODO: Code the test " + this.getName());
        actions.add(echo);
        return actions;
    }

    protected TestGenerator getJavaTestGenerator() {
        return new JavaTestGenerator().withName(this.getName()).withDisabled(this.isDisabled()).withDescription(this.getDescription()).withAuthor(this.getAuthor()).withFramework(this.getFramework()).usePackage(this.getTargetPackage()).useSrcDirectory(super.getSrcDirectory());
    }

    @Override
    protected String getTemplateFilePath() {
        return "classpath:com/consol/citrus/generate/test-template.xml";
    }

    @Override
    public String getSrcDirectory() {
        return super.getSrcDirectory() + File.separator + "resources";
    }

    public void setMarshaller(Jaxb2Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Jaxb2Marshaller getMarshaller() {
        return this.marshaller;
    }

    public NamespacePrefixMapper getNamespacePrefixMapper() {
        return this.namespacePrefixMapper;
    }

    public void setNamespacePrefixMapper(NamespacePrefixMapper namespacePrefixMapper) {
        this.namespacePrefixMapper = namespacePrefixMapper;
    }

    @Override
    public TestGenerator.GeneratorMode getMode() {
        return this.mode;
    }

    public void setMode(TestGenerator.GeneratorMode mode) {
        this.mode = mode;
    }
}

