/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.generate.UnitFramework;
import com.consol.citrus.generate.xml.XmlTestGenerator;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class TestGeneratorMain {
    public static void main(String[] args) {
        TestGeneratorCliOptions options = new TestGeneratorCliOptions();
        try {
            GnuParser cliParser = new GnuParser();
            CommandLine cmd = cliParser.parse((Options)options, args);
            if (cmd.hasOption("help")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("CITRUS test creation", (Options)options);
                return;
            }
            XmlTestGenerator generator = (XmlTestGenerator)new XmlTestGenerator().withName(cmd.getOptionValue("name")).withAuthor(cmd.getOptionValue("author", "Unknown")).withDescription(cmd.getOptionValue("description", "TODO: Description")).usePackage(cmd.getOptionValue("package", "com.consol.citrus")).useSrcDirectory(cmd.getOptionValue("srcdir", CitrusSettings.DEFAULT_TEST_SRC_DIRECTORY)).withFramework(UnitFramework.fromString(cmd.getOptionValue("framework", "testng")));
            generator.create();
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("\n **** CITRUS TEST GENERATOR ****", "\n CLI options:", (Options)options, "");
        }
    }

    private static class TestGeneratorCliOptions
    extends Options {
        private static final long serialVersionUID = 1L;

        public TestGeneratorCliOptions() {
            this.addOption(new Option("help", "print usage help"));
            OptionBuilder.withArgName((String)"name");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the test name (required)");
            OptionBuilder.isRequired((boolean)true);
            this.addOption(OptionBuilder.create((String)"name"));
            OptionBuilder.withArgName((String)"author");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the author of the test (optional)");
            OptionBuilder.isRequired((boolean)false);
            this.addOption(OptionBuilder.create((String)"author"));
            OptionBuilder.withArgName((String)"description");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"describes the test (optional)");
            OptionBuilder.isRequired((boolean)false);
            this.addOption(OptionBuilder.create((String)"description"));
            OptionBuilder.withArgName((String)"package");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the package to use (optional)");
            OptionBuilder.isRequired((boolean)false);
            this.addOption(OptionBuilder.create((String)"package"));
            OptionBuilder.withArgName((String)"srcdir");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the test source directory to use (optional)");
            OptionBuilder.isRequired((boolean)false);
            this.addOption(OptionBuilder.create((String)"srcdir"));
            OptionBuilder.withArgName((String)"framework");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the framework to use (optional) [testng, junit4, junit3]");
            OptionBuilder.isRequired((boolean)false);
            this.addOption(OptionBuilder.create((String)"framework"));
        }
    }
}

