/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate.javadsl;

import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.generate.AbstractTestGenerator;
import com.consol.citrus.generate.TestGenerator;
import com.consol.citrus.generate.UnitFramework;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class JavaTestGenerator<T extends JavaTestGenerator<T>>
extends AbstractTestGenerator<T> {
    private TestGenerator.GeneratorMode mode = TestGenerator.GeneratorMode.CLIENT;

    public JavaTestGenerator() {
        this.withFileExtension(".java");
    }

    @Override
    public void create() {
        if (Character.isLowerCase(this.getName().charAt(0))) {
            throw new CitrusRuntimeException("Test name must start with an uppercase letter");
        }
        this.createJavaTest();
    }

    private void createJavaTest() {
        TypeSpec.Builder testTypeBuilder = TypeSpec.classBuilder((String)this.getName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addJavadoc(this.getJavaDoc()).addMethod(this.getTestMethod(this.getMethodName()));
        if (this.getFramework().equals((Object)UnitFramework.JUNIT5)) {
            testTypeBuilder.addAnnotation(this.getBaseExtension());
        } else {
            testTypeBuilder.superclass(this.getBaseType());
        }
        JavaFile javaFile = this.createJavaFileBuilder(testTypeBuilder).build();
        try {
            javaFile.writeTo(new File(this.getSrcDirectory()));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write java class file", (Throwable)e);
        }
    }

    protected JavaFile.Builder createJavaFileBuilder(TypeSpec.Builder testTypeBuilder) {
        return JavaFile.builder((String)this.getTargetPackage(), (TypeSpec)testTypeBuilder.build()).indent("    ");
    }

    private CodeBlock getJavaDoc() {
        return CodeBlock.builder().add("$L\n\n", new Object[]{Optional.ofNullable(this.getDescription()).orElse(this.getName())}).add("@author $L\n", new Object[]{this.getAuthor()}).add("@since $L\n", new Object[]{this.getCreationDate()}).build();
    }

    protected TypeName getBaseType() {
        if (this.getFramework().equals((Object)UnitFramework.TESTNG)) {
            return ClassName.get((String)"com.consol.citrus.testng", (String)"TestNGCitrusSupport", (String[])new String[0]);
        }
        if (this.getFramework().equals((Object)UnitFramework.JUNIT4)) {
            return ClassName.get((String)"com.consol.citrus.junit", (String)"JUnit4CitrusSupport", (String[])new String[0]);
        }
        throw new CitrusRuntimeException("Unsupported framework: " + this.getFramework());
    }

    protected AnnotationSpec getBaseExtension() {
        ClassName extension = ClassName.get((String)"com.consol.citrus.junit.jupiter", (String)"CitrusBaseExtension", (String[])new String[0]);
        return this.createAnnotationBuilder("org.junit.jupiter.api.extension", "ExtendWith").addMember("value", "$T.class", new Object[]{extension}).build();
    }

    private MethodSpec getTestMethod(String name) {
        ParameterSpec.Builder methodParamBuilder = ParameterSpec.builder(TestCaseRunner.class, (String)"runner", (Modifier[])new Modifier[0]).addAnnotation(CitrusResource.class);
        if (this.getFramework().equals((Object)UnitFramework.TESTNG)) {
            methodParamBuilder.addAnnotation(this.createTestNgAnnotationBuilder("Optional").build());
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.getCitrusAnnotation()).addParameter(methodParamBuilder.build());
        Stream.of(this.getTestAnnotations()).forEach(arg_0 -> ((MethodSpec.Builder)methodBuilder).addAnnotation(arg_0));
        this.getActions().forEach(action -> methodBuilder.addCode(action).addCode("\n\n", new Object[0]));
        return methodBuilder.build();
    }

    protected AnnotationSpec getCitrusAnnotation() {
        return AnnotationSpec.builder(CitrusXmlTest.class).addMember("name", "$S", new Object[]{this.getName()}).build();
    }

    private AnnotationSpec[] getTestAnnotations() {
        switch (this.getFramework()) {
            case JUNIT4: {
                return this.createJunit4TestAnnotations();
            }
            case JUNIT5: {
                return this.createJunit5Annotations();
            }
            case TESTNG: {
                return this.createTestNgTestAnnotations();
            }
        }
        throw new CitrusRuntimeException("Unsupported framework: " + this.getFramework());
    }

    protected List<CodeBlock> getActions() {
        return Collections.emptyList();
    }

    @Override
    public T withMode(TestGenerator.GeneratorMode mode) {
        this.mode = mode;
        return (T)((JavaTestGenerator)this.self);
    }

    @Override
    public String getSrcDirectory() {
        return super.getSrcDirectory() + File.separator + "java";
    }

    @Override
    public TestGenerator.GeneratorMode getMode() {
        return this.mode;
    }

    public void setMode(TestGenerator.GeneratorMode mode) {
        this.mode = mode;
    }

    private AnnotationSpec[] createJunit5Annotations() {
        return this.createHJunitTestAnnotations(this.createAnnotationBuilder("org.junit.jupiter.api", "Test"), this.createAnnotationBuilder("org.junit.jupiter.api", "Disabled"));
    }

    private AnnotationSpec[] createJunit4TestAnnotations() {
        return this.createHJunitTestAnnotations(this.createAnnotationBuilder("org.junit", "Test"), this.createAnnotationBuilder("org.junit", "Ignore"));
    }

    private AnnotationSpec[] createTestNgTestAnnotations() {
        AnnotationSpec.Builder testAnnotationBuilder = this.createTestNgAnnotationBuilder("Test");
        if (this.isDisabled()) {
            testAnnotationBuilder.addMember("enabled", "false", new Object[0]);
        }
        AnnotationSpec.Builder parametersBuilder = this.createTestNgAnnotationBuilder("Parameters");
        parametersBuilder.addMember("value", "$S", new Object[]{"runner"});
        return new AnnotationSpec[]{testAnnotationBuilder.build(), parametersBuilder.build()};
    }

    private AnnotationSpec[] createHJunitTestAnnotations(AnnotationSpec.Builder testAnnotation, AnnotationSpec.Builder disabledAnnotation) {
        if (this.isDisabled()) {
            return new AnnotationSpec[]{testAnnotation.build(), disabledAnnotation.build()};
        }
        return new AnnotationSpec[]{testAnnotation.build()};
    }

    private ClassName getTestNgAnnotation(String annotationName) {
        return ClassName.get((String)"org.testng.annotations", (String)annotationName, (String[])new String[0]);
    }

    private AnnotationSpec.Builder createTestNgAnnotationBuilder(String parameters) {
        return AnnotationSpec.builder((ClassName)this.getTestNgAnnotation(parameters));
    }

    protected AnnotationSpec.Builder createAnnotationBuilder(String packageName, String simpleName) {
        return AnnotationSpec.builder((ClassName)ClassName.get((String)packageName, (String)simpleName, (String[])new String[0]));
    }
}

