/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate.provider.http;

import com.consol.citrus.generate.provider.MessageActionProvider;
import com.consol.citrus.http.message.HttpMessage;
import com.consol.citrus.model.testcase.http.ClientRequestType;
import com.consol.citrus.model.testcase.http.ParamType;
import com.consol.citrus.model.testcase.http.RequestHeadersType;
import com.consol.citrus.model.testcase.http.SendRequestModel;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class SendHttpRequestActionProvider
implements MessageActionProvider<SendRequestModel, HttpMessage> {
    @Override
    public SendRequestModel getAction(String endpoint, HttpMessage message) {
        SendRequestModel request = new SendRequestModel();
        request.setClient(endpoint);
        ClientRequestType requestType = new ClientRequestType();
        ClientRequestType.Body body = new ClientRequestType.Body();
        body.setData((String)message.getPayload(String.class));
        requestType.setBody(body);
        requestType.setPath(Optional.ofNullable(message.getPath()).map(Object::toString).orElse(""));
        RequestHeadersType requestHeaders = new RequestHeadersType();
        requestHeaders.setContentType("application/json");
        message.getHeaders().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("citrus_")).forEach(entry -> {
            RequestHeadersType.Header header = new RequestHeadersType.Header();
            header.setName((String)entry.getKey());
            header.setValue(Optional.ofNullable(entry.getValue()).map(Object::toString).orElse(""));
            requestHeaders.getHeaders().add(header);
        });
        requestType.setHeaders(requestHeaders);
        if (!CollectionUtils.isEmpty((Map)message.getQueryParams())) {
            message.getQueryParams().forEach((key, values) -> values.forEach(value -> {
                ParamType paramType = new ParamType();
                paramType.setName(key);
                paramType.setValue(value);
                requestType.getParams().add(paramType);
            }));
        } else if (StringUtils.hasText((String)message.getQueryParamString())) {
            Stream.of(message.getQueryParamString().split(",")).map(nameValuePair -> nameValuePair.split("=")).forEach(param -> {
                ParamType paramType = new ParamType();
                paramType.setName(param[0]);
                paramType.setValue(param[1]);
                requestType.getParams().add(paramType);
            });
        }
        String method = Optional.ofNullable(message.getRequestMethod()).map(Object::toString).orElse(RequestMethod.POST.name());
        if (RequestMethod.GET.name().equals(method)) {
            request.setGET(requestType);
        } else if (RequestMethod.POST.name().equals(method)) {
            request.setPOST(requestType);
        } else if (RequestMethod.PUT.name().equals(method)) {
            request.setPUT(requestType);
        } else if (RequestMethod.DELETE.name().equals(method)) {
            request.setDELETE(requestType);
        } else if (RequestMethod.HEAD.name().equals(method)) {
            request.setHEAD(requestType);
        } else if (RequestMethod.OPTIONS.name().equals(method)) {
            request.setPOST(requestType);
        } else if (RequestMethod.PATCH.name().equals(method)) {
            request.setPATCH(requestType);
        } else if (RequestMethod.TRACE.name().equals(method)) {
            request.setTRACE(requestType);
        }
        return request;
    }
}

