/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.generate;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.generate.AbstractTestGenerator;
import com.consol.citrus.generate.TestGenerator;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.util.PropertyUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class AbstractTemplateBasedTestGenerator<T extends TestGenerator>
extends AbstractTestGenerator<T> {
    @Override
    public void create() {
        FileUtils.writeToFile((String)this.createContent(this.getTemplateProperties()), (File)this.getTargetFile());
    }

    protected Properties getTemplateProperties() {
        Properties properties = new Properties();
        properties.put("test.name", this.getName());
        properties.put("test.author", this.getAuthor());
        properties.put("test.description", this.getDescription());
        properties.put("test.update.datetime", this.getUpdateDateTime());
        properties.put("test.creation.date", this.getCreationDate());
        properties.put("test.method.name", this.getMethodName());
        properties.put("test.package", this.getTargetPackage());
        properties.put("test.src.directory", this.getSrcDirectory());
        return properties;
    }

    private String createContent(Properties properties) {
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new PathMatchingResourcePatternResolver().getResource(this.getTemplateFilePath()).getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                contentBuilder.append(PropertyUtils.replacePropertiesInString((String)line, (Properties)properties));
                contentBuilder.append("\n");
            }
        }
        catch (FileNotFoundException e) {
            throw new CitrusRuntimeException("Failed to create test case, unable to find test case template", (Throwable)e);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to create test case, error while accessing test case template file", (Throwable)e);
        }
        return contentBuilder.toString();
    }

    protected abstract String getTemplateFilePath();
}

