/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.testng;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestActionRunner;
import com.consol.citrus.TestBehavior;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.testng.AbstractTestNGCitrusTest;
import java.lang.reflect.Method;
import java.util.Date;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.testng.IHookCallBack;
import org.testng.ITestResult;

public class TestNGCitrusSupport
extends AbstractTestNGCitrusTest
implements GherkinTestActionRunner {
    private static final String BUILDER_ATTRIBUTE = "builder";
    private TestCaseRunner testCaseRunner;

    @Override
    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method != null && method.getAnnotation(CitrusTest.class) != null) {
            try {
                this.run(testResult, method, null, testResult.getMethod().getCurrentInvocationCount());
            }
            catch (Exception e) {
                testResult.setThrowable((Throwable)e);
                testResult.setStatus(2);
            }
            super.run(new AbstractTestNGCitrusTest.FakeExecutionCallBack(callBack.getParameters()), testResult);
            if (testResult.getThrowable() != null) {
                if (testResult.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)testResult.getThrowable();
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else {
            super.run(callBack, testResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run(ITestResult testResult, Method method, TestLoader testLoader, int invocationCount) {
        if (method != null && method.getAnnotation(CitrusXmlTest.class) != null) {
            super.run(testResult, method, testLoader, invocationCount);
        } else {
            try {
                if (this.citrus == null) {
                    this.citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)this.applicationContext));
                }
                TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
                TestCaseRunner testCaseBuilder = this.createTestCaseRunner(method, ctx);
                testCaseBuilder.groups(testResult.getMethod().getGroups());
                testResult.setAttribute(BUILDER_ATTRIBUTE, (Object)testCaseBuilder);
                CitrusAnnotations.injectAll((Object)((Object)this), (Citrus)this.citrus, (TestContext)ctx);
                this.invokeTestMethod(testResult, method, testCaseBuilder, ctx, invocationCount);
            }
            finally {
                testResult.removeAttribute(BUILDER_ATTRIBUTE);
            }
        }
    }

    protected void invokeTestMethod(ITestResult testResult, Method method, TestCaseRunner testCaseBuilder, TestContext context, int invocationCount) {
        TestCase testCase = testCaseBuilder.getTestCase();
        try {
            Object[] params = this.resolveParameter(testResult, method, testCase, context, invocationCount);
            testCaseBuilder.start();
            ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])params);
        }
        catch (AssertionError | Exception e) {
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
            throw new TestCaseFailedException((Throwable)e);
        }
        finally {
            testCaseBuilder.stop();
        }
    }

    @Override
    protected Object resolveAnnotatedResource(ITestResult testResult, Class<?> parameterType, TestContext context) {
        Object storedBuilder = testResult.getAttribute(BUILDER_ATTRIBUTE);
        if (TestCaseRunner.class.isAssignableFrom(parameterType)) {
            return storedBuilder;
        }
        if (TestActionRunner.class.isAssignableFrom(parameterType) && storedBuilder instanceof TestActionRunner) {
            return storedBuilder;
        }
        if (GherkinTestActionRunner.class.isAssignableFrom(parameterType) && storedBuilder instanceof GherkinTestActionRunner) {
            return storedBuilder;
        }
        return super.resolveAnnotatedResource(testResult, parameterType, context);
    }

    protected TestCaseRunner createTestCaseRunner(Method method, TestContext context) {
        this.testCaseRunner = new DefaultTestCaseRunner((TestCase)new DefaultTestCase(), context);
        this.testCaseRunner.testClass(((Object)((Object)this)).getClass());
        this.testCaseRunner.name(((Object)((Object)this)).getClass().getSimpleName());
        this.testCaseRunner.packageName(((Object)((Object)this)).getClass().getPackage().getName());
        if (method.getAnnotation(CitrusTest.class) != null) {
            CitrusTest citrusTestAnnotation = method.getAnnotation(CitrusTest.class);
            if (StringUtils.hasText((String)citrusTestAnnotation.name())) {
                this.testCaseRunner.name(citrusTestAnnotation.name());
            } else {
                this.testCaseRunner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
            }
        } else {
            this.testCaseRunner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
        }
        return this.testCaseRunner;
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.testCaseRunner.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.testCaseRunner.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.testCaseRunner.variable(name, value);
    }

    public void name(String name) {
        this.testCaseRunner.name(name);
    }

    public void description(String description) {
        this.testCaseRunner.description(description);
    }

    public void author(String author) {
        this.testCaseRunner.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.testCaseRunner.status(status);
    }

    public void creationDate(Date date) {
        this.testCaseRunner.creationDate(date);
    }
}

