/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.testng.spring;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.CitrusSpringContext;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestBehavior;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestGroupAware;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.XmlTestLoader;
import com.consol.citrus.config.CitrusSpringConfig;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.testng.PrepareTestNGMethodInterceptor;
import com.consol.citrus.testng.TestNGHelper;
import com.consol.citrus.testng.TestNGSuiteListener;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.testng.IHookCallBack;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.Listeners;

@ContextConfiguration(classes={CitrusSpringConfig.class})
@Listeners(value={PrepareTestNGMethodInterceptor.class})
public class TestNGCitrusSpringSupport
extends AbstractTestNGSpringContextTests
implements GherkinTestActionRunner,
TestNGSuiteListener {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Citrus citrus;
    private TestCaseRunner testCaseRunner;

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method != null && method.getAnnotation(CitrusTest.class) != null) {
            try {
                this.run(testResult, method, null, testResult.getMethod().getCurrentInvocationCount());
            }
            catch (Exception e) {
                testResult.setThrowable((Throwable)e);
                testResult.setStatus(2);
            }
            super.run((IHookCallBack)new TestNGHelper.FakeExecutionCallBack(callBack.getParameters()), testResult);
            if (testResult.getThrowable() != null) {
                if (testResult.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)testResult.getThrowable();
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else if (method != null && method.getAnnotation(CitrusXmlTest.class) != null) {
            List<TestLoader> methodTestLoaders = TestNGHelper.createTestLoadersForMethod(method, this::createTestLoader);
            if (!CollectionUtils.isEmpty(methodTestLoaders)) {
                try {
                    this.run(testResult, method, methodTestLoaders.get(testResult.getMethod().getCurrentInvocationCount() % methodTestLoaders.size()), testResult.getMethod().getCurrentInvocationCount());
                }
                catch (Exception e) {
                    testResult.setThrowable((Throwable)e);
                    testResult.setStatus(2);
                }
            }
            super.run((IHookCallBack)new TestNGHelper.FakeExecutionCallBack(callBack.getParameters()), testResult);
            if (testResult.getThrowable() != null) {
                if (testResult.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)testResult.getThrowable();
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else {
            super.run(callBack, testResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(ITestResult testResult, Method method, TestLoader testLoader, int invocationCount) {
        if (method != null && method.getAnnotation(CitrusXmlTest.class) != null) {
            if (this.citrus == null) {
                this.citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)this.applicationContext));
            }
            TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
            TestCase testCase = testLoader.load();
            if (testCase instanceof TestGroupAware) {
                ((TestGroupAware)testCase).setGroups(testResult.getMethod().getGroups());
            }
            TestNGHelper.invokeTestMethod(this.citrus, this, testResult, method, testCase, ctx, invocationCount);
        } else {
            try {
                if (this.citrus == null) {
                    this.citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)this.applicationContext));
                }
                TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
                this.testCaseRunner = TestNGHelper.createTestCaseRunner(this, method, ctx);
                this.testCaseRunner.groups(testResult.getMethod().getGroups());
                testResult.setAttribute("builder", (Object)this.testCaseRunner);
                CitrusAnnotations.injectAll((Object)this, (Citrus)this.citrus, (TestContext)ctx);
                TestNGHelper.invokeTestMethod(this, testResult, method, this.testCaseRunner, ctx, invocationCount);
            }
            finally {
                testResult.removeAttribute("builder");
            }
        }
    }

    @Override
    public void beforeSuite(ITestContext testContext) {
        try {
            this.springTestContextPrepareTestInstance();
        }
        catch (Exception e) {
            throw new CitrusRuntimeException("Failed to initialize Spring test context", (Throwable)e);
        }
        Assert.notNull((Object)this.applicationContext, (String)"Missing proper application context in before suite initialization");
        this.citrus = Citrus.newInstance((CitrusContext)CitrusSpringContext.create((ApplicationContext)this.applicationContext));
        this.citrus.beforeSuite(testContext.getSuite().getName(), testContext.getIncludedGroups());
    }

    @Override
    public void afterSuite(ITestContext testContext) {
        if (this.citrus != null) {
            this.citrus.afterSuite(testContext.getSuite().getName(), testContext.getIncludedGroups());
        }
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    protected TestLoader createTestLoader(String testName, String packageName) {
        return new XmlTestLoader(this.getClass(), testName, packageName, Optional.ofNullable(this.citrus).map(Citrus::getCitrusContext).orElseGet(() -> CitrusSpringContext.create((ApplicationContext)this.applicationContext)));
    }

    protected TestCase getTestCase() {
        return this.createTestLoader(this.getClass().getSimpleName(), this.getClass().getPackage().getName()).load();
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.testCaseRunner.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.testCaseRunner.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.testCaseRunner.variable(name, value);
    }

    public void name(String name) {
        this.testCaseRunner.name(name);
    }

    public void description(String description) {
        this.testCaseRunner.description(description);
    }

    public void author(String author) {
        this.testCaseRunner.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.testCaseRunner.status(status);
    }

    public void creationDate(Date date) {
        this.testCaseRunner.creationDate(date);
    }
}

