/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.testng;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestBehavior;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.testng.TestNGHelper;
import com.consol.citrus.testng.TestNGSuiteListener;
import com.consol.citrus.testng.TestNGTestListener;
import java.lang.reflect.Method;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestContext;
import org.testng.ITestResult;

public class TestNGCitrusSupport
implements IHookable,
TestNGTestListener,
TestNGSuiteListener,
GherkinTestActionRunner {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Citrus citrus;
    private TestCaseRunner delegate;

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method != null && method.getAnnotation(CitrusTest.class) != null) {
            try {
                this.run(testResult, method, testResult.getMethod().getCurrentInvocationCount());
            }
            catch (Exception e) {
                testResult.setThrowable((Throwable)e);
                testResult.setStatus(2);
            }
            if (testResult.getThrowable() != null) {
                if (testResult.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)testResult.getThrowable();
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else {
            if (method != null && method.getAnnotation(CitrusXmlTest.class) != null) {
                throw new CitrusRuntimeException("Unsupported XML test annotation - please add Spring support");
            }
            callBack.runTestMethod(testResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(ITestResult testResult, Method method, int invocationCount) {
        if (method != null && method.getAnnotation(CitrusXmlTest.class) != null) {
            throw new CitrusRuntimeException("Unsupported XML test annotation - please add Spring support");
        }
        try {
            if (this.citrus == null) {
                this.citrus = Citrus.newInstance();
            }
            TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
            TestCaseRunner runner = TestNGHelper.createTestCaseRunner(this, method, ctx);
            runner.groups(testResult.getMethod().getGroups());
            testResult.setAttribute("builder", (Object)runner);
            this.delegate = runner;
            CitrusAnnotations.injectAll((Object)this, (Citrus)this.citrus, (TestContext)ctx);
            TestNGHelper.invokeTestMethod(this, testResult, method, runner, ctx, invocationCount);
        }
        finally {
            testResult.removeAttribute("builder");
        }
    }

    @Override
    public final void before() {
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance();
            CitrusAnnotations.injectCitrusFramework((Object)this, (Citrus)this.citrus);
        }
        this.before(this.citrus.getCitrusContext());
    }

    protected void before(CitrusContext context) {
    }

    @Override
    public final void after() {
        if (this.citrus != null) {
            this.after(this.citrus.getCitrusContext());
        }
    }

    protected void after(CitrusContext context) {
    }

    @Override
    public final void beforeSuite(ITestContext testContext) {
        this.citrus = Citrus.newInstance();
        CitrusAnnotations.injectCitrusFramework((Object)this, (Citrus)this.citrus);
        this.beforeSuite(this.citrus.getCitrusContext());
        this.citrus.beforeSuite(testContext.getSuite().getName(), testContext.getIncludedGroups());
    }

    protected void beforeSuite(CitrusContext context) {
    }

    @Override
    public final void afterSuite(ITestContext testContext) {
        if (this.citrus != null) {
            this.afterSuite(this.citrus.getCitrusContext());
            this.citrus.afterSuite(testContext.getSuite().getName(), testContext.getIncludedGroups());
        }
    }

    protected void afterSuite(CitrusContext context) {
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.delegate.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.delegate.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.delegate.variable(name, value);
    }

    public void name(String name) {
        this.delegate.name(name);
    }

    public void description(String description) {
        this.delegate.description(description);
    }

    public void author(String author) {
        this.delegate.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.delegate.status(status);
    }

    public void creationDate(Date date) {
        this.delegate.creationDate(date);
    }
}

