/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.testng;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusSettings;
import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestResult;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.TestSourceAware;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.TestCaseFailedException;
import com.consol.citrus.testng.TestNGParameterHelper;
import com.consol.citrus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.testng.IHookCallBack;
import org.testng.ITestResult;

public final class TestNGHelper {
    public static final String BUILDER_ATTRIBUTE = "builder";
    private static final Logger LOG = LoggerFactory.getLogger(TestNGHelper.class);

    private TestNGHelper() {
    }

    public static void invokeTestMethod(Citrus citrus, Object target, ITestResult testResult, Method method, TestCase testCase, TestContext context, int invocationCount) {
        try {
            ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])TestNGParameterHelper.resolveParameter(target, testResult, method, testCase, context, invocationCount));
        }
        catch (TestCaseFailedException e) {
            throw e;
        }
        catch (AssertionError | Exception e) {
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
            testCase.finish(context);
            throw new TestCaseFailedException((Throwable)e);
        }
        citrus.run((TestAction)testCase, context);
    }

    public static void invokeTestMethod(Object target, ITestResult testResult, Method method, TestCaseRunner runner, TestContext context, int invocationCount) {
        TestCase testCase = runner.getTestCase();
        try {
            Object[] params = TestNGParameterHelper.resolveParameter(target, testResult, method, testCase, context, invocationCount);
            runner.start();
            ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])params);
        }
        catch (AssertionError | Exception e) {
            testCase.setTestResult(TestResult.failed((String)testCase.getName(), (String)testCase.getTestClass().getName(), (Throwable)e));
            throw new TestCaseFailedException((Throwable)e);
        }
        finally {
            runner.stop();
        }
    }

    public static TestCaseRunner createTestCaseRunner(Object target, Method method, TestContext context) {
        DefaultTestCaseRunner testCaseRunner = new DefaultTestCaseRunner((TestCase)new DefaultTestCase(), context);
        testCaseRunner.testClass(target.getClass());
        testCaseRunner.name(target.getClass().getSimpleName());
        testCaseRunner.packageName(target.getClass().getPackage().getName());
        if (method.getAnnotation(CitrusTest.class) != null) {
            CitrusTest citrusTestAnnotation = method.getAnnotation(CitrusTest.class);
            if (StringUtils.hasText((String)citrusTestAnnotation.name())) {
                testCaseRunner.name(citrusTestAnnotation.name());
            } else {
                testCaseRunner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
            }
        } else {
            testCaseRunner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
        }
        return testCaseRunner;
    }

    public static List<TestLoader> createTestLoadersForMethod(Method method, TestLoaderProvider provider) {
        ArrayList<TestLoader> methodTestLoaders = new ArrayList<TestLoader>();
        if (method.getAnnotation(CitrusXmlTest.class) != null) {
            String[] packagesToScan;
            CitrusXmlTest citrusTestAnnotation = method.getAnnotation(CitrusXmlTest.class);
            String[] testNames = new String[]{};
            if (citrusTestAnnotation.name().length > 0) {
                testNames = citrusTestAnnotation.name();
            } else if (citrusTestAnnotation.packageScan().length == 0 && citrusTestAnnotation.sources().length == 0) {
                testNames = new String[]{method.getName()};
            }
            String testPackage = StringUtils.hasText((String)citrusTestAnnotation.packageName()) ? citrusTestAnnotation.packageName() : method.getDeclaringClass().getPackage().getName();
            for (String testName : testNames) {
                methodTestLoaders.add(provider.createTestLoader(testName, testPackage));
            }
            for (String source : citrusTestAnnotation.sources()) {
                TestLoader testLoader;
                Resource file = FileUtils.getFileResource((String)source);
                Object methodPackageName = "";
                if (source.startsWith("classpath:")) {
                    methodPackageName = source.substring("classpath:".length());
                }
                if (StringUtils.hasLength((String)methodPackageName) && ((String)methodPackageName).contains("/")) {
                    methodPackageName = ((String)methodPackageName).substring(0, ((String)methodPackageName).lastIndexOf("/"));
                }
                if ((testLoader = provider.createTestLoader(FileUtils.getBaseName((String)file.getFilename()), ((String)methodPackageName).replace("/", "."))) instanceof TestSourceAware) {
                    ((TestSourceAware)testLoader).setSource(source);
                    methodTestLoaders.add(testLoader);
                    continue;
                }
                LOG.warn(String.format("Test loader %s is not able to handle test source %s", testLoader.getClass(), source));
            }
            for (String packageScan : packagesToScan = citrusTestAnnotation.packageScan()) {
                try {
                    for (String fileNamePattern : CitrusSettings.getXmlTestFileNamePattern()) {
                        Resource[] fileResources;
                        for (Resource fileResource : fileResources = new PathMatchingResourcePatternResolver().getResources(packageScan.replace('.', File.separatorChar) + fileNamePattern)) {
                            Object filePath = fileResource.getFile().getParentFile().getCanonicalPath();
                            if (packageScan.startsWith("file:")) {
                                filePath = "file:" + (String)filePath;
                            }
                            filePath = ((String)filePath).substring(((String)filePath).indexOf(packageScan.replace('.', File.separatorChar)));
                            methodTestLoaders.add(provider.createTestLoader(FileUtils.getBaseName((String)fileResource.getFilename()), (String)filePath));
                        }
                    }
                }
                catch (IOException | RuntimeException e) {
                    throw new CitrusRuntimeException("Unable to locate file resources for test package '" + packageScan + "'", (Throwable)e);
                }
            }
        }
        return methodTestLoaders;
    }

    public static final class FakeExecutionCallBack
    implements IHookCallBack {
        private Object[] parameters;

        public FakeExecutionCallBack(Object[] parameters) {
            this.parameters = Arrays.copyOf(parameters, parameters.length);
        }

        public void runTestMethod(ITestResult testResult) {
        }

        public Object[] getParameters() {
            return Arrays.copyOf(this.parameters, this.parameters.length);
        }
    }

    @FunctionalInterface
    public static interface TestLoaderProvider {
        public TestLoader createTestLoader(String var1, String var2);
    }
}

