/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.testng.spring;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.annotations.CitrusTestSource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.testng.spring.TestNGCitrusSpringSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.internal.MethodInstance;

public class TestNGCitrusSpringMethodInterceptor
implements IMethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TestNGCitrusSpringMethodInterceptor.class);

    public List<IMethodInstance> intercept(List<IMethodInstance> methods, ITestContext context) {
        ArrayList<IMethodInstance> interceptedMethods = new ArrayList<IMethodInstance>();
        for (IMethodInstance method : methods) {
            boolean baseMethodAdded = false;
            if (method.getInstance() instanceof TestNGCitrusSpringSupport) {
                int i;
                Resource[] fileResources;
                String[] packagesToScan;
                if (method.getMethod().getConstructorOrMethod().getMethod().getAnnotation(CitrusTestSource.class) != null) {
                    CitrusTestSource citrusTestAnnotation = method.getMethod().getConstructorOrMethod().getMethod().getAnnotation(CitrusTestSource.class);
                    if (citrusTestAnnotation.name().length > 1) {
                        for (int i2 = 0; i2 < citrusTestAnnotation.name().length; ++i2) {
                            if (i2 == 0) {
                                baseMethodAdded = true;
                                interceptedMethods.add(method);
                                continue;
                            }
                            interceptedMethods.add((IMethodInstance)new MethodInstance(method.getMethod()));
                        }
                    }
                    for (String packageName : packagesToScan = citrusTestAnnotation.packageScan()) {
                        try {
                            for (String fileNamePattern : CitrusSettings.getTestFileNamePattern((String)citrusTestAnnotation.type())) {
                                fileResources = new PathMatchingResourcePatternResolver().getResources(packageName.replace('.', File.separatorChar) + fileNamePattern);
                                for (i = 0; i < fileResources.length; ++i) {
                                    if (i == 0 && !baseMethodAdded) {
                                        baseMethodAdded = true;
                                        interceptedMethods.add(method);
                                        continue;
                                    }
                                    interceptedMethods.add((IMethodInstance)new MethodInstance(method.getMethod()));
                                }
                            }
                        }
                        catch (IOException e) {
                            log.error("Unable to locate file resources for test package '" + packageName + "'", (Throwable)e);
                        }
                    }
                } else if (method.getMethod().getConstructorOrMethod().getMethod().getAnnotation(CitrusXmlTest.class) != null) {
                    CitrusXmlTest citrusXmlTestAnnotation = method.getMethod().getConstructorOrMethod().getMethod().getAnnotation(CitrusXmlTest.class);
                    if (citrusXmlTestAnnotation.name().length > 1) {
                        for (int i3 = 0; i3 < citrusXmlTestAnnotation.name().length; ++i3) {
                            if (i3 == 0) {
                                baseMethodAdded = true;
                                interceptedMethods.add(method);
                                continue;
                            }
                            interceptedMethods.add((IMethodInstance)new MethodInstance(method.getMethod()));
                        }
                    }
                    for (String packageName : packagesToScan = citrusXmlTestAnnotation.packageScan()) {
                        try {
                            for (String fileNamePattern : CitrusSettings.getTestFileNamePattern((String)"spring")) {
                                fileResources = new PathMatchingResourcePatternResolver().getResources(packageName.replace('.', File.separatorChar) + fileNamePattern);
                                for (i = 0; i < fileResources.length; ++i) {
                                    if (i == 0 && !baseMethodAdded) {
                                        baseMethodAdded = true;
                                        interceptedMethods.add(method);
                                        continue;
                                    }
                                    interceptedMethods.add((IMethodInstance)new MethodInstance(method.getMethod()));
                                }
                            }
                        }
                        catch (IOException e) {
                            log.error("Unable to locate file resources for test package '" + packageName + "'", (Throwable)e);
                        }
                    }
                }
            }
            if (baseMethodAdded) continue;
            interceptedMethods.add(method);
        }
        return interceptedMethods;
    }
}

