/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.testng;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusContext;
import com.consol.citrus.GherkinTestActionRunner;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestBehavior;
import com.consol.citrus.TestCaseMetaInfo;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.TestGroupAware;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusTestSource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.DefaultTestLoader;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.TestSourceAware;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.testng.TestNGCitrusMethodInterceptor;
import com.consol.citrus.testng.TestNGHelper;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Listeners;

@Listeners(value={TestNGCitrusMethodInterceptor.class})
public class TestNGCitrusSupport
implements IHookable,
GherkinTestActionRunner {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected Citrus citrus;
    private TestCaseRunner delegate;

    public void run(IHookCallBack callBack, ITestResult testResult) {
        Method method = testResult.getMethod().getConstructorOrMethod().getMethod();
        if (method == null) {
            callBack.runTestMethod(testResult);
            return;
        }
        List<TestLoader> methodTestLoaders = TestNGHelper.createMethodTestLoaders(method, this::createTestLoader);
        if (method.getAnnotation(CitrusTest.class) != null || method.getAnnotation(CitrusTestSource.class) != null) {
            try {
                this.run(testResult, method, methodTestLoaders, testResult.getMethod().getCurrentInvocationCount());
                testResult.setStatus(1);
            }
            catch (Exception e) {
                testResult.setThrowable((Throwable)e);
                testResult.setStatus(2);
            }
            if (testResult.getThrowable() != null) {
                if (testResult.getThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)testResult.getThrowable();
                }
                throw new CitrusRuntimeException(testResult.getThrowable());
            }
        } else {
            if (method.getAnnotation(CitrusXmlTest.class) != null) {
                throw new CitrusRuntimeException("Unsupported XML test annotation - please add Spring support");
            }
            callBack.runTestMethod(testResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(ITestResult testResult, Method method, List<TestLoader> methodTestLoaders, int invocationCount) {
        if (method.getAnnotation(CitrusXmlTest.class) != null) {
            throw new CitrusRuntimeException("Unsupported XML test annotation - please add Spring support");
        }
        try {
            DefaultTestLoader testLoader;
            if (this.citrus == null) {
                this.citrus = Citrus.newInstance();
            }
            TestContext ctx = this.prepareTestContext(this.citrus.getCitrusContext().createTestContext());
            TestCaseRunner runner = TestNGHelper.createTestCaseRunner(this, method, ctx);
            runner.groups(testResult.getMethod().getGroups());
            testResult.setAttribute("builder", (Object)runner);
            this.delegate = runner;
            CitrusAnnotations.injectAll((Object)this, (Citrus)this.citrus, (TestContext)ctx);
            if (method.getAnnotation(CitrusTestSource.class) != null && !methodTestLoaders.isEmpty()) {
                String[] sources;
                testLoader = methodTestLoaders.get(invocationCount % methodTestLoaders.size());
                if (testLoader instanceof TestSourceAware && (sources = method.getAnnotation(CitrusTestSource.class).sources()).length > 0) {
                    ((TestSourceAware)testLoader).setSource(sources[0]);
                }
            } else {
                testLoader = new DefaultTestLoader();
            }
            CitrusAnnotations.injectAll((Object)testLoader, (Citrus)this.citrus, (TestContext)ctx);
            CitrusAnnotations.injectTestRunner((Object)testLoader, (TestCaseRunner)runner);
            testLoader.configureTestCase(t -> {
                if (t instanceof TestGroupAware) {
                    ((TestGroupAware)t).setGroups(testResult.getMethod().getGroups());
                }
            });
            TestNGHelper.invokeTestMethod(this, testResult, method, (TestLoader)testLoader, ctx, invocationCount);
        }
        finally {
            testResult.removeAttribute("builder");
        }
    }

    @BeforeClass(alwaysRun=true)
    public final void before() {
        if (this.citrus == null) {
            this.citrus = Citrus.newInstance();
            CitrusAnnotations.injectCitrusFramework((Object)this, (Citrus)this.citrus);
        }
        this.before(this.citrus.getCitrusContext());
    }

    protected void before(CitrusContext context) {
    }

    @AfterClass(alwaysRun=true)
    public final void after() {
        if (this.citrus != null) {
            this.after(this.citrus.getCitrusContext());
        }
    }

    protected void after(CitrusContext context) {
    }

    @BeforeSuite(alwaysRun=true)
    public final void beforeSuite(ITestContext testContext) {
        this.citrus = Citrus.newInstance();
        CitrusAnnotations.injectCitrusFramework((Object)this, (Citrus)this.citrus);
        this.beforeSuite(this.citrus.getCitrusContext());
        this.citrus.beforeSuite(testContext.getSuite().getName(), testContext.getIncludedGroups());
    }

    protected void beforeSuite(CitrusContext context) {
    }

    @AfterSuite(alwaysRun=true)
    public final void afterSuite(ITestContext testContext) {
        if (this.citrus != null) {
            this.afterSuite(this.citrus.getCitrusContext());
            this.citrus.afterSuite(testContext.getSuite().getName(), testContext.getIncludedGroups());
        }
    }

    protected void afterSuite(CitrusContext context) {
    }

    protected TestContext prepareTestContext(TestContext testContext) {
        return testContext;
    }

    protected TestLoader createTestLoader(String testName, String packageName, String type) {
        TestLoader testLoader = (TestLoader)TestLoader.lookup((String)type).orElseThrow(() -> new CitrusRuntimeException(String.format("Missing test loader for type '%s'", type)));
        testLoader.setTestClass(this.getClass());
        testLoader.setTestName(testName);
        testLoader.setPackageName(packageName);
        return testLoader;
    }

    public <T extends TestAction> T run(TestActionBuilder<T> builder) {
        return (T)this.delegate.run(builder);
    }

    public <T extends TestAction> TestActionBuilder<T> applyBehavior(TestBehavior behavior) {
        return this.delegate.applyBehavior(behavior);
    }

    public <T> T variable(String name, T value) {
        return (T)this.delegate.variable(name, value);
    }

    public void name(String name) {
        this.delegate.name(name);
    }

    public void description(String description) {
        this.delegate.description(description);
    }

    public void author(String author) {
        this.delegate.author(author);
    }

    public void status(TestCaseMetaInfo.Status status) {
        this.delegate.status(status);
    }

    public void creationDate(Date date) {
        this.delegate.creationDate(date);
    }
}

