/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.testng;

import com.consol.citrus.CitrusSettings;
import com.consol.citrus.DefaultTestCase;
import com.consol.citrus.DefaultTestCaseRunner;
import com.consol.citrus.TestCase;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.annotations.CitrusTest;
import com.consol.citrus.annotations.CitrusTestSource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.TestSourceAware;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.testng.TestNGParameterHelper;
import com.consol.citrus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.testng.IHookCallBack;
import org.testng.ITestResult;

public final class TestNGHelper {
    public static final String BUILDER_ATTRIBUTE = "builder";
    private static final Logger LOG = LoggerFactory.getLogger(TestNGHelper.class);

    private TestNGHelper() {
    }

    public static void invokeTestMethod(Object target, ITestResult testResult, Method method, TestLoader testLoader, TestContext context, int invocationCount) {
        Object[] params = TestNGParameterHelper.resolveParameter(target, testResult, method, context, invocationCount);
        testLoader.configureTestCase(t -> TestNGParameterHelper.injectTestParameters(method, t, params));
        testLoader.doWithTestCase(t -> ReflectionUtils.invokeMethod((Method)method, (Object)target, (Object[])params));
        testLoader.load();
    }

    public static TestCaseRunner createTestCaseRunner(Object target, Method method, TestContext context) {
        DefaultTestCaseRunner testCaseRunner = new DefaultTestCaseRunner((TestCase)new DefaultTestCase(), context);
        testCaseRunner.testClass(target.getClass());
        testCaseRunner.name(target.getClass().getSimpleName());
        testCaseRunner.packageName(target.getClass().getPackage().getName());
        if (method.getAnnotation(CitrusTest.class) != null) {
            CitrusTest citrusTestAnnotation = method.getAnnotation(CitrusTest.class);
            if (StringUtils.hasText((String)citrusTestAnnotation.name())) {
                testCaseRunner.name(citrusTestAnnotation.name());
            } else {
                testCaseRunner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
            }
        } else {
            testCaseRunner.name(method.getDeclaringClass().getSimpleName() + "." + method.getName());
        }
        return testCaseRunner;
    }

    public static List<TestLoader> createMethodTestLoaders(Method method, TestLoaderProvider provider) {
        ArrayList<TestLoader> methodTestLoaders = new ArrayList<TestLoader>();
        if (method.getAnnotation(CitrusTestSource.class) != null) {
            CitrusTestSource citrusTestAnnotation = method.getAnnotation(CitrusTestSource.class);
            methodTestLoaders.addAll(TestNGHelper.createMethodTestLoaders(method, citrusTestAnnotation.name(), citrusTestAnnotation.packageName(), citrusTestAnnotation.packageScan(), citrusTestAnnotation.sources(), provider, citrusTestAnnotation.type(), CitrusSettings.getTestFileNamePattern((String)citrusTestAnnotation.type())));
        } else if (method.getAnnotation(CitrusXmlTest.class) != null) {
            CitrusXmlTest citrusTestAnnotation = method.getAnnotation(CitrusXmlTest.class);
            methodTestLoaders.addAll(TestNGHelper.createMethodTestLoaders(method, citrusTestAnnotation.name(), citrusTestAnnotation.packageName(), citrusTestAnnotation.packageScan(), citrusTestAnnotation.sources(), provider, "spring", CitrusSettings.getTestFileNamePattern((String)"spring")));
        }
        return methodTestLoaders;
    }

    private static List<? extends TestLoader> createMethodTestLoaders(Method method, String[] testNames, String testPackageName, String[] packagesToScan, String[] sources, TestLoaderProvider provider, String type, Set<String> testFileNamePattern) {
        ArrayList<TestLoader> methodTestLoaders = new ArrayList<TestLoader>();
        String packageName = method.getDeclaringClass().getPackage().getName();
        if (StringUtils.hasText((String)testPackageName)) {
            packageName = testPackageName;
        }
        if (testNames.length > 0) {
            for (String name : testNames) {
                methodTestLoaders.add(provider.createTestLoader(name, packageName, type));
            }
        } else if (packagesToScan.length == 0 && sources.length == 0) {
            methodTestLoaders.add(provider.createTestLoader(method.getName(), packageName, type));
        }
        for (String source : sources) {
            TestLoader testLoader;
            Resource file = FileUtils.getFileResource((String)source);
            String sourceFilePackageName = "";
            if (source.startsWith("classpath:")) {
                sourceFilePackageName = source.substring("classpath:".length());
            }
            if (StringUtils.hasLength((String)sourceFilePackageName) && sourceFilePackageName.contains("/")) {
                sourceFilePackageName = sourceFilePackageName.substring(0, sourceFilePackageName.lastIndexOf("/"));
            }
            if ((testLoader = provider.createTestLoader(FileUtils.getBaseName((String)file.getFilename()), sourceFilePackageName.replace("/", "."), type)) instanceof TestSourceAware) {
                ((TestSourceAware)testLoader).setSource(source);
                methodTestLoaders.add(testLoader);
                continue;
            }
            LOG.warn(String.format("Test loader %s is not able to handle test source %s", testLoader.getClass(), source));
        }
        for (String packageScan : packagesToScan) {
            try {
                for (String fileNamePattern : testFileNamePattern) {
                    Resource[] fileResources;
                    for (Resource fileResource : fileResources = new PathMatchingResourcePatternResolver().getResources(packageScan.replace('.', File.separatorChar) + fileNamePattern)) {
                        Object filePath = fileResource.getFile().getParentFile().getCanonicalPath();
                        if (packageScan.startsWith("file:")) {
                            filePath = "file:" + (String)filePath;
                        }
                        filePath = ((String)filePath).substring(((String)filePath).indexOf(packageScan.replace('.', File.separatorChar)));
                        methodTestLoaders.add(provider.createTestLoader(FileUtils.getBaseName((String)fileResource.getFilename()), (String)filePath, type));
                    }
                }
            }
            catch (IOException | RuntimeException e) {
                throw new CitrusRuntimeException("Unable to locate file resources for test package '" + packageScan + "'", (Throwable)e);
            }
        }
        return methodTestLoaders;
    }

    @FunctionalInterface
    public static interface TestLoaderProvider {
        public TestLoader createTestLoader(String var1, String var2, String var3);
    }

    public static final class FakeExecutionCallBack
    implements IHookCallBack {
        private Object[] parameters;

        public FakeExecutionCallBack(Object[] parameters) {
            this.parameters = Arrays.copyOf(parameters, parameters.length);
        }

        public void runTestMethod(ITestResult testResult) {
        }

        public Object[] getParameters() {
            return Arrays.copyOf(this.parameters, this.parameters.length);
        }
    }
}

