/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.binary;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.DefaultMessageValidator;
import com.consol.citrus.validation.context.ValidationContext;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;

public class BinaryMessageValidator
extends DefaultMessageValidator {
    private static final int BUFFER_SIZE = 1024;

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) throws ValidationException {
        try (InputStream receivedInput = (InputStream)receivedMessage.getPayload(InputStream.class);
             InputStream controlInput = (InputStream)controlMessage.getPayload(InputStream.class);){
            ReadableByteChannel receivedBytes = Channels.newChannel(receivedInput);
            ReadableByteChannel controlBytes = Channels.newChannel(controlInput);
            ByteBuffer receivedBuffer = ByteBuffer.allocateDirect(1024);
            ByteBuffer controlBuffer = ByteBuffer.allocateDirect(1024);
            while (true) {
                int n1 = receivedBytes.read(receivedBuffer);
                int n2 = controlBytes.read(controlBuffer);
                if (n1 == -1 || n2 == -1) {
                    return;
                }
                receivedBuffer.flip();
                controlBuffer.flip();
                for (int i = 0; i < Math.min(n1, n2); ++i) {
                    if (receivedBuffer.get() == controlBuffer.get()) continue;
                    throw new ValidationException("Received input stream is not equal to given control");
                }
                receivedBuffer.compact();
                receivedBuffer.compact();
            }
        }
        catch (IOException e) {
            throw new ValidationException("Failed to compare binary input streams", (Throwable)e);
        }
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.BINARY.toString());
    }
}

