/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.matcher.hamcrest;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.spi.ResourcePathTypeResolver;
import com.consol.citrus.spi.TypeResolver;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HamcrestMatcherProvider {
    public static final Logger LOG = LoggerFactory.getLogger(HamcrestMatcherProvider.class);
    public static final String RESOURCE_PATH = "META-INF/citrus/hamcrest/matcher/provider";
    public static final TypeResolver TYPE_RESOLVER = new ResourcePathTypeResolver("META-INF/citrus/hamcrest/matcher/provider");

    public static Optional<HamcrestMatcherProvider> lookup(String matcherName) {
        try {
            return Optional.of((HamcrestMatcherProvider)TYPE_RESOLVER.resolve(matcherName, new Object[0]));
        }
        catch (CitrusRuntimeException e) {
            LOG.warn(String.format("Failed to resolve Hamcrest matcher provider from resource '%s/%s'", RESOURCE_PATH, matcherName));
            return Optional.empty();
        }
    }

    public static boolean canResolve(String matcherName) {
        try {
            TYPE_RESOLVER.resolve(matcherName, new Object[0]);
            return true;
        }
        catch (CitrusRuntimeException e) {
            return false;
        }
    }

    public String getName();

    public Matcher<?> provideMatcher(String var1);
}

