/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.json;

import com.consol.citrus.json.schema.SimpleJsonSchema;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class JsonSchemaRepository
implements BeanNameAware,
InitializingBean {
    private String name;
    private List<SimpleJsonSchema> schemas = new ArrayList<SimpleJsonSchema>();
    private List<String> locations = new ArrayList<String>();
    private static Logger log = LoggerFactory.getLogger(JsonSchemaRepository.class);

    public void setBeanName(String name) {
        this.name = name;
    }

    public void afterPropertiesSet() throws Exception {
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        for (String location : this.locations) {
            Resource[] findings;
            for (Resource resource : findings = resourcePatternResolver.getResources(location)) {
                this.addSchemas(resource);
            }
        }
    }

    private void addSchemas(Resource resource) throws Exception {
        if (resource.getFilename().endsWith(".json")) {
            if (log.isDebugEnabled()) {
                log.debug("Loading json schema resource " + resource.getFilename());
            }
            SimpleJsonSchema simpleJsonSchema = new SimpleJsonSchema(resource);
            simpleJsonSchema.afterPropertiesSet();
            this.schemas.add(simpleJsonSchema);
        } else {
            log.warn("Skipped resource other than json schema for repository (" + resource.getFilename() + ")");
        }
    }

    public String getName() {
        return this.name;
    }

    public List<SimpleJsonSchema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<SimpleJsonSchema> schemas) {
        this.schemas = schemas;
    }

    public static Logger getLog() {
        return log;
    }

    public static void setLog(Logger log) {
        JsonSchemaRepository.log = log;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }
}

