/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.callback.AbstractValidationCallback;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.springframework.util.Assert;

public abstract class JsonMappingValidationCallback<T>
extends AbstractValidationCallback<T> {
    private ObjectMapper jsonMapper;
    private Class<T> resultType;

    public JsonMappingValidationCallback(Class<T> resultType) {
        this.resultType = resultType;
    }

    public JsonMappingValidationCallback(Class<T> resultType, ObjectMapper jsonMapper) {
        this.resultType = resultType;
        this.jsonMapper = jsonMapper;
    }

    public void validate(Message message, TestContext context) {
        this.validate(this.readJson(message), message.getHeaders(), context);
    }

    private T readJson(Message message) {
        if (this.jsonMapper == null) {
            Assert.notNull((Object)this.referenceResolver, (String)"Json mapping validation callback requires object mapper instance or proper reference resolver with nested bean definition of type marshaller");
            this.jsonMapper = (ObjectMapper)this.referenceResolver.resolve(ObjectMapper.class);
        }
        try {
            return (T)this.jsonMapper.readValue((String)message.getPayload(String.class), this.resultType);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to unmarshal message payload", (Throwable)e);
        }
    }
}

