/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.json.JsonPathUtils;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.AbstractMessageValidator;
import com.consol.citrus.validation.ValidationUtils;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.json.JsonTextMessageValidator;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ReadContext;
import java.util.Map;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JsonPathMessageValidator
extends AbstractMessageValidator<JsonPathMessageValidationContext> {
    private static Logger log = LoggerFactory.getLogger(JsonPathMessageValidator.class);

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, JsonPathMessageValidationContext validationContext) throws ValidationException {
        if (CollectionUtils.isEmpty((Map)validationContext.getJsonPathExpressions())) {
            return;
        }
        if (receivedMessage.getPayload() == null || !StringUtils.hasText((String)((String)receivedMessage.getPayload(String.class)))) {
            throw new ValidationException("Unable to validate message elements - receive message payload was empty");
        }
        log.debug("Start JSONPath element validation ...");
        try {
            JSONParser parser = new JSONParser(1984);
            Object receivedJson = parser.parse((String)receivedMessage.getPayload(String.class));
            DocumentContext readerContext = JsonPath.parse((Object)receivedJson);
            for (Map.Entry entry : validationContext.getJsonPathExpressions().entrySet()) {
                Object expectedValue = entry.getValue();
                if (expectedValue instanceof String) {
                    expectedValue = context.replaceDynamicContentInString(String.valueOf(expectedValue));
                }
                String jsonPathExpression = context.replaceDynamicContentInString((String)entry.getKey());
                Object jsonPathResult = JsonPathUtils.evaluate((ReadContext)readerContext, (String)jsonPathExpression);
                ValidationUtils.validateValues((Object)jsonPathResult, expectedValue, (String)jsonPathExpression, (TestContext)context);
                if (!log.isDebugEnabled()) continue;
                log.debug("Validating element: " + jsonPathExpression + "='" + expectedValue + "': OK.");
            }
            log.info("JSONPath element validation successful: All values OK");
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException("Failed to parse JSON text", (Throwable)e);
        }
    }

    protected Class<JsonPathMessageValidationContext> getRequiredValidationContextType() {
        return JsonPathMessageValidationContext.class;
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return new JsonTextMessageValidator().supportsMessageType(messageType, message);
    }
}

