/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.json.JsonSchemaRepository;
import com.consol.citrus.json.JsonUtils;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.AbstractMessageValidator;
import com.consol.citrus.validation.ValidationUtils;
import com.consol.citrus.validation.json.JsonMessageValidationContext;
import com.consol.citrus.validation.json.schema.JsonSchemaValidation;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JsonTextMessageValidator
extends AbstractMessageValidator<JsonMessageValidationContext>
implements ApplicationContextAware {
    private boolean strict;
    private ApplicationContext applicationContext;
    private JsonSchemaValidation jsonSchemaValidation = new JsonSchemaValidation();

    public JsonTextMessageValidator() {
        this.strict = Boolean.parseBoolean(System.getProperty("citrus.json.message.validation.strict", "true"));
    }

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, JsonMessageValidationContext validationContext) {
        block9: {
            if (controlMessage == null || controlMessage.getPayload() == null) {
                this.log.debug("Skip message payload validation as no control message was defined");
                return;
            }
            this.log.debug("Start JSON message validation ...");
            if (validationContext.isSchemaValidationEnabled()) {
                this.performSchemaValidation(receivedMessage, context, validationContext);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Received message:\n" + receivedMessage);
                this.log.debug("Control message:\n" + controlMessage);
            }
            String receivedJsonText = (String)receivedMessage.getPayload(String.class);
            String controlJsonText = context.replaceDynamicContentInString((String)controlMessage.getPayload(String.class));
            try {
                if (!StringUtils.hasText((String)controlJsonText)) {
                    this.log.debug("Skip message payload validation as no control message was defined");
                    return;
                }
                Assert.isTrue((boolean)StringUtils.hasText((String)receivedJsonText), (String)"Validation failed - expected message contents, but received empty message!");
                JSONParser parser = new JSONParser(1984);
                Object receivedJson = parser.parse(receivedJsonText);
                DocumentContext readContext = JsonPath.parse((Object)receivedJson);
                Object controlJson = parser.parse(controlJsonText);
                if (receivedJson instanceof JSONObject) {
                    this.validateJson("$.", (JSONObject)receivedJson, (JSONObject)controlJson, validationContext, context, (ReadContext)readContext);
                    break block9;
                }
                if (receivedJson instanceof JSONArray) {
                    JSONObject tempReceived = new JSONObject();
                    tempReceived.put((Object)"array", receivedJson);
                    JSONObject tempControl = new JSONObject();
                    tempControl.put((Object)"array", controlJson);
                    this.validateJson("$.", tempReceived, tempControl, validationContext, context, (ReadContext)readContext);
                    break block9;
                }
                throw new CitrusRuntimeException("Unsupported json type " + receivedJson.getClass());
            }
            catch (IllegalArgumentException e) {
                throw new ValidationException(String.format("Failed to validate JSON text:%n%s", receivedJsonText), (Throwable)e);
            }
            catch (ParseException e) {
                throw new CitrusRuntimeException("Failed to parse JSON text", (Throwable)e);
            }
        }
        this.log.info("JSON message validation successful: All values OK");
    }

    private void performSchemaValidation(Message receivedMessage, TestContext context, JsonMessageValidationContext validationContext) {
        this.log.debug("Starting Json schema validation ...");
        ProcessingReport report = this.jsonSchemaValidation.validate(receivedMessage, this.findSchemaRepositories(context), validationContext, context.getReferenceResolver());
        if (!report.isSuccess()) {
            this.log.error("Failed to validate Json schema for message:\n" + (String)receivedMessage.getPayload(String.class));
            throw new ValidationException(this.constructErrorMessage(report));
        }
        this.log.info("Json schema validation successful: All values OK");
    }

    private List<JsonSchemaRepository> findSchemaRepositories(TestContext context) {
        return new ArrayList<JsonSchemaRepository>(context.getReferenceResolver().resolveAll(JsonSchemaRepository.class).values());
    }

    public void validateJson(String elementName, JSONObject receivedJson, JSONObject controlJson, JsonMessageValidationContext validationContext, TestContext context, ReadContext readContext) {
        if (this.strict) {
            Assert.isTrue((controlJson.size() == receivedJson.size() ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Number of JSON entries not equal for element: '" + elementName + "'"), (Object)controlJson.size(), (Object)receivedJson.size()));
        }
        for (Map.Entry controlJsonEntry : controlJson.entrySet()) {
            Object receivedValue;
            String controlKey = (String)controlJsonEntry.getKey();
            Assert.isTrue((boolean)receivedJson.containsKey((Object)controlKey), (String)("Missing JSON entry: + '" + controlKey + "'"));
            Object controlValue = controlJsonEntry.getValue();
            if (this.isIgnored(controlKey, controlValue, receivedValue = receivedJson.get((Object)controlKey), validationContext.getIgnoreExpressions(), readContext)) continue;
            if (controlValue == null) {
                Assert.isTrue((receivedValue == null ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for entry: '" + controlKey + "'"), null, (Object)receivedValue));
            } else if (receivedValue != null) {
                if (ValidationMatcherUtils.isValidationMatcherExpression((String)controlValue.toString())) {
                    ValidationMatcherUtils.resolveValidationMatcher((String)controlKey, (String)receivedValue.toString(), (String)controlValue.toString(), (TestContext)context);
                } else if (controlValue instanceof JSONObject) {
                    Assert.isTrue((boolean)(receivedValue instanceof JSONObject), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Type mismatch for JSON entry '" + controlKey + "'"), (Object)JSONObject.class.getSimpleName(), (Object)receivedValue.getClass().getSimpleName()));
                    this.validateJson(controlKey, (JSONObject)receivedValue, (JSONObject)controlValue, validationContext, context, readContext);
                } else if (controlValue instanceof JSONArray) {
                    Assert.isTrue((boolean)(receivedValue instanceof JSONArray), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Type mismatch for JSON entry '" + controlKey + "'"), (Object)JSONArray.class.getSimpleName(), (Object)receivedValue.getClass().getSimpleName()));
                    JSONArray jsonArrayControl = (JSONArray)controlValue;
                    JSONArray jsonArrayReceived = (JSONArray)receivedValue;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Validating JSONArray containing " + jsonArrayControl.size() + " entries");
                    }
                    if (this.strict) {
                        Assert.isTrue((jsonArrayControl.size() == jsonArrayReceived.size() ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)("JSONArray size mismatch for JSON entry '" + controlKey + "'"), (Object)jsonArrayControl.size(), (Object)jsonArrayReceived.size()));
                    }
                    for (int i = 0; i < jsonArrayControl.size(); ++i) {
                        if (jsonArrayControl.get(i).getClass().isAssignableFrom(JSONObject.class)) {
                            Assert.isTrue((boolean)jsonArrayReceived.get(i).getClass().isAssignableFrom(JSONObject.class), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Value types not equal for entry: '" + jsonArrayControl.get(i) + "'"), (Object)JSONObject.class.getName(), (Object)jsonArrayReceived.get(i).getClass().getName()));
                            this.validateJson(controlKey, (JSONObject)jsonArrayReceived.get(i), (JSONObject)jsonArrayControl.get(i), validationContext, context, readContext);
                            continue;
                        }
                        Assert.isTrue((boolean)jsonArrayControl.get(i).equals(jsonArrayReceived.get(i)), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for entry: '" + jsonArrayControl.get(i) + "'"), (Object)jsonArrayControl.get(i), (Object)jsonArrayReceived.get(i)));
                    }
                } else {
                    Assert.isTrue((boolean)controlValue.equals(receivedValue), (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for entry: '" + controlKey + "'"), controlValue, (Object)receivedValue));
                }
            } else if (ValidationMatcherUtils.isValidationMatcherExpression((String)controlValue.toString())) {
                ValidationMatcherUtils.resolveValidationMatcher((String)controlKey, null, (String)controlValue.toString(), (TestContext)context);
            } else {
                Assert.isTrue((!StringUtils.hasText((String)controlValue.toString()) ? 1 : 0) != 0, (String)ValidationUtils.buildValueMismatchErrorMessage((String)("Values not equal for entry '" + controlKey + "'"), (Object)controlValue.toString(), null));
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("Validation successful for JSON entry '" + controlKey + "' (" + controlValue + ")");
        }
    }

    public boolean isIgnored(String controlKey, Object controlValue, Object receivedJson, Set<String> ignoreExpressions, ReadContext readContext) {
        if (controlValue != null && controlValue.toString().trim().equals("@ignore@")) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("JSON entry: '" + controlKey + "' is ignored by placeholder '" + "@ignore@" + "'");
            }
            return true;
        }
        for (String jsonPathExpression : ignoreExpressions) {
            Object foundEntry = readContext.read(jsonPathExpression, new Predicate[0]);
            if (foundEntry instanceof JSONArray && ((JSONArray)foundEntry).contains(receivedJson)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("JSON entry: '" + controlKey + "' is ignored - skip value validation");
                }
                return true;
            }
            if (foundEntry == null || !foundEntry.equals(receivedJson)) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug("JSON entry: '" + controlKey + "' is ignored - skip value validation");
            }
            return true;
        }
        return false;
    }

    protected Class<JsonMessageValidationContext> getRequiredValidationContextType() {
        return JsonMessageValidationContext.class;
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.JSON.name()) && JsonUtils.hasJsonPayload((Message)message);
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public JsonTextMessageValidator strict(boolean strict) {
        this.setStrict(strict);
        return this;
    }

    private String constructErrorMessage(ProcessingReport report) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Json validation failed: ");
        report.forEach(processingMessage -> stringBuilder.append(processingMessage.getMessage()));
        return stringBuilder.toString();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    void setJsonSchemaValidation(JsonSchemaValidation jsonSchemaValidation) {
        this.jsonSchemaValidation = jsonSchemaValidation;
    }
}

