/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable.dictionary.json;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.variable.dictionary.DataDictionary;
import com.consol.citrus.variable.dictionary.json.AbstractJsonDataDictionary;
import java.util.Map;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JsonMappingDataDictionary
extends AbstractJsonDataDictionary {
    private static Logger log = LoggerFactory.getLogger(JsonMappingDataDictionary.class);

    protected Message interceptMessage(Message message, String messageType, TestContext context) {
        if (message.getPayload() == null || !StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            return message;
        }
        JSONParser parser = new JSONParser(1984);
        try {
            Object json = parser.parse((String)message.getPayload(String.class));
            if (json instanceof JSONObject) {
                this.traverseJsonData((JSONObject)json, "", context);
            } else if (json instanceof JSONArray) {
                JSONObject tempJson = new JSONObject();
                tempJson.put((Object)"root", json);
                this.traverseJsonData(tempJson, "", context);
            } else {
                throw new CitrusRuntimeException("Unsupported json type " + json.getClass());
            }
            message.setPayload((Object)json.toString());
        }
        catch (ParseException e) {
            log.warn("Data dictionary unable to parse JSON object", (Throwable)e);
        }
        return message;
    }

    public <T> T translate(String jsonPath, T value, TestContext context) {
        block7: {
            block8: {
                block6: {
                    if (!this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.EXACT)) break block6;
                    if (this.mappings.containsKey(jsonPath)) {
                        if (log.isDebugEnabled()) {
                            log.debug(String.format("Data dictionary setting element '%s' with value: %s", jsonPath, this.mappings.get(jsonPath)));
                        }
                        return (T)this.convertIfNecessary(context.replaceDynamicContentInString((String)this.mappings.get(jsonPath)), value);
                    }
                    break block7;
                }
                if (!this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.ENDS_WITH)) break block8;
                for (Map.Entry entry : this.mappings.entrySet()) {
                    if (!jsonPath.endsWith((String)entry.getKey())) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(String.format("Data dictionary setting element '%s' with value: %s", jsonPath, entry.getValue()));
                    }
                    return (T)this.convertIfNecessary(context.replaceDynamicContentInString((String)entry.getValue()), value);
                }
                break block7;
            }
            if (!this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.STARTS_WITH)) break block7;
            for (Map.Entry entry : this.mappings.entrySet()) {
                if (!jsonPath.startsWith((String)entry.getKey())) continue;
                if (log.isDebugEnabled()) {
                    log.debug(String.format("Data dictionary setting element '%s' with value: %s", jsonPath, entry.getValue()));
                }
                return (T)this.convertIfNecessary(context.replaceDynamicContentInString((String)entry.getValue()), value);
            }
        }
        return value;
    }

    private void traverseJsonData(JSONObject jsonData, String jsonPath, TestContext context) {
        for (Map.Entry jsonEntry : jsonData.entrySet()) {
            if (jsonEntry.getValue() instanceof JSONObject) {
                this.traverseJsonData((JSONObject)jsonEntry.getValue(), StringUtils.hasText((String)jsonPath) ? jsonPath + "." + jsonEntry.getKey() : jsonEntry.getKey().toString(), context);
                continue;
            }
            if (jsonEntry.getValue() instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)jsonEntry.getValue();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    if (jsonArray.get(i) instanceof JSONObject) {
                        this.traverseJsonData((JSONObject)jsonArray.get(i), String.format((StringUtils.hasText((String)jsonPath) ? jsonPath + "." + jsonEntry.getKey() : jsonEntry.getKey().toString()) + "[%s]", i), context);
                        continue;
                    }
                    jsonArray.set(i, this.translate(String.format((StringUtils.hasText((String)jsonPath) ? jsonPath + "." + jsonEntry.getKey() : jsonEntry.getKey().toString()) + "[%s]", i), jsonArray.get(i), context));
                }
                continue;
            }
            jsonEntry.setValue(this.translate(StringUtils.hasText((String)jsonPath) ? jsonPath + "." + jsonEntry.getKey() : jsonEntry.getKey().toString(), jsonEntry.getValue() != null ? (Object)jsonEntry.getValue() : null, context));
        }
    }
}

