/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable.dictionary.json;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.json.JsonPathMessageConstructionInterceptor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import com.consol.citrus.variable.dictionary.json.AbstractJsonDataDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JsonPathMappingDataDictionary
extends AbstractJsonDataDictionary {
    private static Logger log = LoggerFactory.getLogger(JsonPathMappingDataDictionary.class);

    protected Message interceptMessage(Message message, String messageType, TestContext context) {
        if (message.getPayload() == null || !StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            return message;
        }
        JsonPathMessageConstructionInterceptor delegateInterceptor = new JsonPathMessageConstructionInterceptor();
        delegateInterceptor.setIgnoreNotFound(true);
        delegateInterceptor.setJsonPathExpressions(this.mappings);
        return delegateInterceptor.interceptMessage(message, messageType, context);
    }

    public <T> T translate(String jsonPath, T value, TestContext context) {
        return value;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getPathMappingStrategy() != null && !this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.EXACT)) {
            log.warn(String.format("%s ignores path mapping strategy other than %s", ((Object)((Object)this)).getClass().getSimpleName(), DataDictionary.PathMappingStrategy.EXACT));
        }
        super.afterPropertiesSet();
    }
}

