/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json;

import com.consol.citrus.builder.WithExpressions;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.UnknownElementException;
import com.consol.citrus.message.AbstractMessageProcessor;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.message.MessageType;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class JsonPathMessageProcessor
extends AbstractMessageProcessor {
    private static Logger log = LoggerFactory.getLogger(JsonPathMessageProcessor.class);
    private final Map<String, Object> jsonPathExpressions;
    private final boolean ignoreNotFound;

    public JsonPathMessageProcessor() {
        this(new Builder());
    }

    private JsonPathMessageProcessor(Builder builder) {
        this.jsonPathExpressions = builder.expressions;
        this.ignoreNotFound = builder.ignoreNotFound;
    }

    public void processMessage(Message message, TestContext context) {
        if (message.getPayload() == null || !StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            return;
        }
        try {
            JSONParser parser = new JSONParser(4032);
            Object jsonData = parser.parse((String)message.getPayload(String.class));
            DocumentContext documentContext = JsonPath.parse((Object)jsonData);
            for (Map.Entry<String, Object> entry : this.jsonPathExpressions.entrySet()) {
                String valueExpression;
                String jsonPathExpression;
                block12: {
                    Object value;
                    jsonPathExpression = entry.getKey();
                    valueExpression = context.replaceDynamicContentInString(entry.getValue().toString());
                    if (valueExpression.equals("true")) {
                        value = true;
                    } else if (valueExpression.equals("false")) {
                        value = false;
                    } else {
                        try {
                            value = NumberUtils.parseNumber((String)valueExpression, Integer.class);
                        }
                        catch (IllegalArgumentException e) {
                            value = valueExpression;
                        }
                    }
                    try {
                        documentContext.set(jsonPathExpression, value, new Predicate[0]);
                    }
                    catch (PathNotFoundException e) {
                        if (this.ignoreNotFound) break block12;
                        throw new UnknownElementException(String.format("Could not find element for expression: %s", jsonPathExpression), (Throwable)e);
                    }
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Element " + jsonPathExpression + " was set to value: " + valueExpression);
            }
            message.setPayload((Object)jsonData.toString());
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException("Failed to parse JSON text", (Throwable)e);
        }
    }

    public boolean supportsMessageType(String messageType) {
        return MessageType.JSON.toString().equalsIgnoreCase(messageType);
    }

    public Map<String, Object> getJsonPathExpressions() {
        return this.jsonPathExpressions;
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public static final class Builder
    implements MessageProcessor.Builder<JsonPathMessageProcessor, Builder>,
    WithExpressions<Builder> {
        private final Map<String, Object> expressions = new LinkedHashMap<String, Object>();
        private boolean ignoreNotFound = false;

        public Builder expressions(Map<String, Object> expressions) {
            this.expressions.putAll(expressions);
            return this;
        }

        public Builder expression(String expression, Object expectedValue) {
            this.expressions.put(expression, expectedValue);
            return this;
        }

        public Builder ignoreNotFound(boolean ignore) {
            this.ignoreNotFound = ignore;
            return this;
        }

        public JsonPathMessageProcessor build() {
            return new JsonPathMessageProcessor(this);
        }
    }
}

