/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json.schema;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.json.JsonSchemaRepository;
import com.consol.citrus.json.schema.SimpleJsonSchema;
import com.consol.citrus.message.Message;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.validation.json.JsonMessageValidationContext;
import com.consol.citrus.validation.json.report.GraciousProcessingReport;
import com.consol.citrus.validation.json.schema.JsonSchemaFilter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.DevNullProcessingReport;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class JsonSchemaValidation {
    private final JsonSchemaFilter jsonSchemaFilter;
    private ObjectMapper objectMapper = new ObjectMapper();

    public JsonSchemaValidation() {
        this(new JsonSchemaFilter());
    }

    public JsonSchemaValidation(JsonSchemaFilter jsonSchemaFilter) {
        this.jsonSchemaFilter = jsonSchemaFilter;
    }

    public ProcessingReport validate(Message message, List<JsonSchemaRepository> schemaRepositories, JsonMessageValidationContext validationContext, ReferenceResolver referenceResolver) {
        return this.validate(message, this.jsonSchemaFilter.filter(schemaRepositories, validationContext, referenceResolver));
    }

    private GraciousProcessingReport validate(Message message, List<SimpleJsonSchema> jsonSchemas) {
        if (jsonSchemas.isEmpty()) {
            return new GraciousProcessingReport(true);
        }
        LinkedList<ProcessingReport> processingReports = new LinkedList<ProcessingReport>();
        for (SimpleJsonSchema simpleJsonSchema : jsonSchemas) {
            processingReports.add(this.validate(message, simpleJsonSchema));
        }
        return new GraciousProcessingReport(processingReports);
    }

    private ProcessingReport validate(Message message, SimpleJsonSchema simpleJsonSchema) {
        try {
            JsonNode receivedJson = this.objectMapper.readTree((String)message.getPayload(String.class));
            if (receivedJson.isEmpty()) {
                return new DevNullProcessingReport();
            }
            return simpleJsonSchema.getSchema().validate(receivedJson);
        }
        catch (ProcessingException | IOException e) {
            throw new CitrusRuntimeException("Failed to validate Json schema", e);
        }
    }
}

