/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.json.schema;

import com.consol.citrus.common.InitializingPhase;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.github.fge.jackson.JsonLoader;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.springframework.core.io.Resource;

public class SimpleJsonSchema
implements InitializingPhase {
    private JsonSchemaFactory jsonSchemaFactory = JsonSchemaFactory.byDefault();
    private Resource json;
    private JsonSchema schema;

    public SimpleJsonSchema(Resource resource) {
        this.json = resource;
    }

    public SimpleJsonSchema() {
    }

    public void initialize() {
        try {
            this.schema = this.jsonSchemaFactory.getJsonSchema(JsonLoader.fromFile((File)this.json.getFile()));
        }
        catch (ProcessingException | IOException e) {
            throw new CitrusRuntimeException("Failed to load Json schema", e);
        }
    }

    public Resource getJson() {
        return this.json;
    }

    public void setJson(Resource json) {
        this.json = json;
    }

    public JsonSchema getSchema() {
        return this.schema;
    }

    public void setSchema(JsonSchema schema) {
        this.schema = schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleJsonSchema that = (SimpleJsonSchema)o;
        return Objects.equals(this.jsonSchemaFactory, that.jsonSchemaFactory) && Objects.equals(this.json, that.json) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.jsonSchemaFactory, this.json, this.schema);
    }
}

