/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageProcessor;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.spi.ReferenceResolverAware;
import com.consol.citrus.validation.AbstractValidationProcessor;
import com.consol.citrus.validation.GenericValidationProcessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.springframework.util.Assert;

public abstract class JsonMappingValidationProcessor<T>
extends AbstractValidationProcessor<T> {
    private ObjectMapper mapper;
    private final Class<T> resultType;

    public JsonMappingValidationProcessor(Class<T> resultType) {
        this.resultType = resultType;
    }

    public JsonMappingValidationProcessor(Class<T> resultType, ObjectMapper mapper) {
        this.resultType = resultType;
        this.mapper = mapper;
    }

    public void validate(Message message, TestContext context) {
        this.validate(this.readJson(message), message.getHeaders(), context);
    }

    private T readJson(Message message) {
        if (this.mapper == null) {
            Assert.notNull((Object)this.referenceResolver, (String)"Json mapping validation callback requires object mapper instance or proper reference resolver with nested bean definition of type marshaller");
            this.mapper = (ObjectMapper)this.referenceResolver.resolve(ObjectMapper.class);
        }
        try {
            return (T)this.mapper.readValue((String)message.getPayload(String.class), this.resultType);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to unmarshal message payload", (Throwable)e);
        }
    }

    public static final class Builder<T>
    implements MessageProcessor.Builder<JsonMappingValidationProcessor<T>, Builder<T>>,
    ReferenceResolverAware {
        private final Class<T> resultType;
        private ObjectMapper mapper;
        private GenericValidationProcessor<T> validationProcessor;
        private ReferenceResolver referenceResolver;

        public Builder(Class<T> type) {
            this.resultType = type;
        }

        public static <T> Builder<T> validate(Class<T> type) {
            return new Builder<T>(type);
        }

        public Builder<T> validator(GenericValidationProcessor<T> validationProcessor) {
            this.validationProcessor = validationProcessor;
            return this;
        }

        public Builder<T> mapper(ObjectMapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder<T> withReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
            return this;
        }

        public JsonMappingValidationProcessor<T> build() {
            if (this.mapper == null) {
                if (this.referenceResolver != null) {
                    this.mapper = (ObjectMapper)this.referenceResolver.resolve(ObjectMapper.class);
                } else {
                    throw new CitrusRuntimeException("Missing object mapper - please set proper mapper or reference resolver");
                }
            }
            if (this.validationProcessor == null) {
                throw new CitrusRuntimeException("Missing validation processor - please add proper validation logic");
            }
            return new JsonMappingValidationProcessor<T>(this.resultType, this.mapper){

                public void validate(T payload, Map<String, Object> headers, TestContext context) {
                    validationProcessor.validate(payload, headers, context);
                }
            };
        }

        public void setReferenceResolver(ReferenceResolver referenceResolver) {
            this.referenceResolver = referenceResolver;
        }
    }
}

