/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.json.schema;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.json.JsonSchemaRepository;
import com.consol.citrus.json.schema.SimpleJsonSchema;
import com.consol.citrus.message.Message;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.util.IsJsonPredicate;
import com.consol.citrus.validation.SchemaValidator;
import com.consol.citrus.validation.json.JsonMessageValidationContext;
import com.consol.citrus.validation.json.report.GraciousProcessingReport;
import com.consol.citrus.validation.json.schema.JsonSchemaFilter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.report.DevNullProcessingReport;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaValidation
implements SchemaValidator<JsonMessageValidationContext> {
    private Logger log = LoggerFactory.getLogger(JsonSchemaValidation.class);
    private final JsonSchemaFilter jsonSchemaFilter;
    private ObjectMapper objectMapper = new ObjectMapper();

    public JsonSchemaValidation() {
        this(new JsonSchemaFilter());
    }

    public JsonSchemaValidation(JsonSchemaFilter jsonSchemaFilter) {
        this.jsonSchemaFilter = jsonSchemaFilter;
    }

    public void validate(Message message, TestContext context, JsonMessageValidationContext validationContext) {
        this.log.debug("Starting Json schema validation ...");
        ProcessingReport report = this.validate(message, this.findSchemaRepositories(context), validationContext, context.getReferenceResolver());
        if (!report.isSuccess()) {
            this.log.error("Failed to validate Json schema for message:\n" + (String)message.getPayload(String.class));
            throw new ValidationException(this.constructErrorMessage(report));
        }
        this.log.info("Json schema validation successful: All values OK");
    }

    private String constructErrorMessage(ProcessingReport report) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Json validation failed: ");
        report.forEach(processingMessage -> stringBuilder.append(processingMessage.getMessage()));
        return stringBuilder.toString();
    }

    private List<JsonSchemaRepository> findSchemaRepositories(TestContext context) {
        return new ArrayList<JsonSchemaRepository>(context.getReferenceResolver().resolveAll(JsonSchemaRepository.class).values());
    }

    public ProcessingReport validate(Message message, List<JsonSchemaRepository> schemaRepositories, JsonMessageValidationContext validationContext, ReferenceResolver referenceResolver) {
        return this.validate(message, this.jsonSchemaFilter.filter(schemaRepositories, validationContext, referenceResolver));
    }

    private GraciousProcessingReport validate(Message message, List<SimpleJsonSchema> jsonSchemas) {
        if (jsonSchemas.isEmpty()) {
            return new GraciousProcessingReport(true);
        }
        LinkedList<ProcessingReport> processingReports = new LinkedList<ProcessingReport>();
        for (SimpleJsonSchema simpleJsonSchema : jsonSchemas) {
            processingReports.add(this.validate(message, simpleJsonSchema));
        }
        return new GraciousProcessingReport(processingReports);
    }

    private ProcessingReport validate(Message message, SimpleJsonSchema simpleJsonSchema) {
        try {
            JsonNode receivedJson = this.objectMapper.readTree((String)message.getPayload(String.class));
            if (receivedJson.isEmpty()) {
                return new DevNullProcessingReport();
            }
            return simpleJsonSchema.getSchema().validate(receivedJson);
        }
        catch (ProcessingException | IOException e) {
            throw new CitrusRuntimeException("Failed to validate Json schema", e);
        }
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return "JSON".equals(messageType) || message != null && IsJsonPredicate.getInstance().test((String)message.getPayload(String.class));
    }
}

