/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.variable.dictionary.json;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.validation.json.JsonPathMessageProcessor;
import com.consol.citrus.variable.dictionary.DataDictionary;
import com.consol.citrus.variable.dictionary.json.AbstractJsonDataDictionary;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class JsonPathMappingDataDictionary
extends AbstractJsonDataDictionary {
    private static Logger log = LoggerFactory.getLogger(JsonPathMappingDataDictionary.class);

    protected void processMessage(Message message, TestContext context) {
        if (message.getPayload() == null || !StringUtils.hasText((String)((String)message.getPayload(String.class)))) {
            return;
        }
        JsonPathMessageProcessor delegateProcessor = ((JsonPathMessageProcessor.Builder)new JsonPathMessageProcessor.Builder().ignoreNotFound(true).expressions((Map)this.mappings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue())))).build();
        delegateProcessor.processMessage(message, context);
    }

    public <T> T translate(String jsonPath, T value, TestContext context) {
        return value;
    }

    public void initialize() {
        if (this.getPathMappingStrategy() != null && !this.getPathMappingStrategy().equals((Object)DataDictionary.PathMappingStrategy.EXACT)) {
            log.warn(String.format("%s ignores path mapping strategy other than %s", ((Object)((Object)this)).getClass().getSimpleName(), DataDictionary.PathMappingStrategy.EXACT));
        }
        super.initialize();
    }
}

