/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.validation.text;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageType;
import com.consol.citrus.validation.DefaultMessageValidator;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PlainTextMessageValidator
extends DefaultMessageValidator {
    public static final String IGNORE_NEWLINE_TYPE_PROPERTY = "citrus.plaintext.validation.ignore.newline.type";
    public static final String IGNORE_NEWLINE_TYPE_ENV = "CITRUS_PLAINTEXT_VALIDATION_IGNORE_NEWLINE_TYPE";
    public static final String IGNORE_WHITESPACE_PROPERTY = "citrus.plaintext.validation.ignore.whitespace";
    public static final String IGNORE_WHITESPACE_ENV = "CITRUS_PLAINTEXT_VALIDATION_IGNORE_WHITESPACE";
    private boolean ignoreNewLineType = Boolean.valueOf(System.getProperty("citrus.plaintext.validation.ignore.newline.type", System.getenv("CITRUS_PLAINTEXT_VALIDATION_IGNORE_NEWLINE_TYPE") != null ? System.getenv("CITRUS_PLAINTEXT_VALIDATION_IGNORE_NEWLINE_TYPE") : "false"));
    private boolean ignoreWhitespace = Boolean.valueOf(System.getProperty("citrus.plaintext.validation.ignore.whitespace", System.getenv("CITRUS_PLAINTEXT_VALIDATION_IGNORE_WHITESPACE") != null ? System.getenv("CITRUS_PLAINTEXT_VALIDATION_IGNORE_WHITESPACE") : "false"));

    public void validateMessage(Message receivedMessage, Message controlMessage, TestContext context, ValidationContext validationContext) throws ValidationException {
        if (controlMessage == null || controlMessage.getPayload() == null) {
            this.log.debug("Skip message payload validation as no control message was defined");
            return;
        }
        this.log.debug("Start text message validation");
        try {
            String resultValue = this.normalizeWhitespace(((String)receivedMessage.getPayload(String.class)).trim());
            String controlValue = this.normalizeWhitespace(context.replaceDynamicContentInString(((String)controlMessage.getPayload(String.class)).trim()));
            controlValue = this.processIgnoreStatements(controlValue, resultValue);
            controlValue = this.processVariableStatements(controlValue, resultValue, context);
            if (ValidationMatcherUtils.isValidationMatcherExpression((String)controlValue)) {
                ValidationMatcherUtils.resolveValidationMatcher((String)"payload", (String)resultValue, (String)controlValue, (TestContext)context);
                return;
            }
            this.validateText(resultValue, controlValue);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Failed to validate text content", (Throwable)e);
        }
        this.log.info("Text validation successful: All values OK");
    }

    private String processIgnoreStatements(String control, String result) {
        if (control.equals("@ignore@")) {
            return control;
        }
        Pattern whitespacePattern = Pattern.compile("[\\W]");
        Pattern ignorePattern = Pattern.compile("@ignore\\(?(\\d*)\\)?@");
        Matcher ignoreMatcher = ignorePattern.matcher(control);
        while (ignoreMatcher.find()) {
            String actualValue;
            if (ignoreMatcher.groupCount() > 0 && StringUtils.hasText((String)ignoreMatcher.group(1))) {
                int end = ignoreMatcher.start() + Integer.valueOf(ignoreMatcher.group(1));
                if (end > result.length()) {
                    end = result.length();
                }
                actualValue = ignoreMatcher.start() > result.length() ? "" : result.substring(ignoreMatcher.start(), end);
            } else {
                actualValue = result.substring(ignoreMatcher.start());
                Matcher whitespaceMatcher = whitespacePattern.matcher(actualValue);
                if (whitespaceMatcher.find()) {
                    actualValue = actualValue.substring(0, whitespaceMatcher.start());
                }
            }
            control = ignoreMatcher.replaceFirst(actualValue);
            ignoreMatcher = ignorePattern.matcher(control);
        }
        return control;
    }

    private String processVariableStatements(String control, String result, TestContext context) {
        if (control.equals("@ignore@")) {
            return control;
        }
        Pattern whitespacePattern = Pattern.compile("[^a-zA-Z_0-9\\-\\.]");
        Pattern variablePattern = Pattern.compile("@variable\\(?'?([a-zA-Z_0-9\\-\\.]*)'?\\)?@");
        Matcher variableMatcher = variablePattern.matcher(control);
        while (variableMatcher.find()) {
            String actualValue = result.substring(variableMatcher.start());
            Matcher whitespaceMatcher = whitespacePattern.matcher(actualValue);
            if (whitespaceMatcher.find()) {
                actualValue = actualValue.substring(0, whitespaceMatcher.start());
            }
            control = variableMatcher.replaceFirst(actualValue);
            context.setVariable(variableMatcher.group(1), (Object)actualValue);
            variableMatcher = variablePattern.matcher(control);
        }
        return control;
    }

    private void validateText(String receivedMessagePayload, String controlMessagePayload) {
        if (!StringUtils.hasText((String)controlMessagePayload)) {
            this.log.debug("Skip message payload validation as no control message was defined");
            return;
        }
        Assert.isTrue((boolean)StringUtils.hasText((String)receivedMessagePayload), (String)"Validation failed - expected message contents, but received empty message!");
        if (!receivedMessagePayload.equals(controlMessagePayload)) {
            if (StringUtils.trimAllWhitespace((String)receivedMessagePayload).equals(StringUtils.trimAllWhitespace((String)controlMessagePayload))) {
                throw new ValidationException("Text values not equal (only whitespaces!), expected '" + controlMessagePayload + "' but was '" + receivedMessagePayload + "'");
            }
            throw new ValidationException("Text values not equal, expected '" + controlMessagePayload + "' but was '" + receivedMessagePayload + "'");
        }
    }

    private String normalizeWhitespace(String payload) {
        if (this.ignoreWhitespace) {
            StringBuilder result = new StringBuilder();
            boolean lastWasSpace = true;
            for (int i = 0; i < payload.length(); ++i) {
                char c = payload.charAt(i);
                if (Character.isWhitespace(c)) {
                    if (!lastWasSpace) {
                        result.append(' ');
                    }
                    lastWasSpace = true;
                    continue;
                }
                result.append(c);
                lastWasSpace = false;
            }
            return result.toString().trim();
        }
        if (this.ignoreNewLineType) {
            return payload.replaceAll("\\r(\\n)?", "\n");
        }
        return payload;
    }

    public boolean supportsMessageType(String messageType, Message message) {
        return messageType.equalsIgnoreCase(MessageType.PLAINTEXT.toString());
    }

    public boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }

    public boolean isIgnoreNewLineType() {
        return this.ignoreNewLineType;
    }

    public void setIgnoreNewLineType(boolean ignoreNewLineType) {
        this.ignoreNewLineType = ignoreNewLineType;
    }
}

