/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.websocket.endpoint;

import com.consol.citrus.endpoint.AbstractEndpoint;
import com.consol.citrus.endpoint.EndpointConfiguration;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.messaging.SelectiveConsumer;
import com.consol.citrus.websocket.endpoint.WebSocketConsumer;
import com.consol.citrus.websocket.endpoint.WebSocketEndpointConfiguration;
import com.consol.citrus.websocket.endpoint.WebSocketProducer;
import com.consol.citrus.websocket.handler.CitrusWebSocketHandler;

public class WebSocketEndpoint
extends AbstractEndpoint {
    private WebSocketProducer wsProducer;
    private WebSocketConsumer wsConsumer;

    public WebSocketEndpoint(WebSocketEndpointConfiguration endpointConfiguration) {
        super((EndpointConfiguration)endpointConfiguration);
    }

    public SelectiveConsumer createConsumer() {
        if (this.wsConsumer == null) {
            this.wsConsumer = new WebSocketConsumer(this.getConsumerName(), this.getEndpointConfiguration());
        }
        return this.wsConsumer;
    }

    public Producer createProducer() {
        if (this.wsProducer == null) {
            this.wsProducer = new WebSocketProducer(this.getProducerName(), this.getEndpointConfiguration());
        }
        return this.wsProducer;
    }

    public WebSocketEndpointConfiguration getEndpointConfiguration() {
        return (WebSocketEndpointConfiguration)super.getEndpointConfiguration();
    }

    public void setWebSocketHandler(CitrusWebSocketHandler handler) {
        this.getEndpointConfiguration().setHandler(handler);
    }
}

