/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.websocket.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.messaging.Producer;
import com.consol.citrus.websocket.endpoint.WebSocketEndpointConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.web.socket.WebSocketMessage;

public class WebSocketProducer
implements Producer {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketProducer.class);
    private final String name;
    private final WebSocketEndpointConfiguration endpointConfiguration;

    public WebSocketProducer(String name, WebSocketEndpointConfiguration endpointConfiguration) {
        this.name = name;
        this.endpointConfiguration = endpointConfiguration;
    }

    public void send(Message message, TestContext context) {
        Assert.notNull((Object)message, (String)"Message is empty - unable to send empty message");
        LOG.info("Sending WebSocket message ...");
        context.onOutboundMessage(message);
        WebSocketMessage wsMessage = this.endpointConfiguration.getMessageConverter().convertOutbound(message, this.endpointConfiguration, context);
        if (this.endpointConfiguration.getHandler().sendMessage(wsMessage)) {
            LOG.info("WebSocket Message was successfully sent");
        }
    }

    public String getName() {
        return this.name;
    }
}

