/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.websocket.message;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageConverter;
import com.consol.citrus.websocket.endpoint.WebSocketEndpointConfiguration;
import com.consol.citrus.websocket.message.WebSocketMessage;
import java.nio.ByteBuffer;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.web.socket.BinaryMessage;
import org.springframework.web.socket.TextMessage;

public class WebSocketMessageConverter
implements MessageConverter<org.springframework.web.socket.WebSocketMessage, org.springframework.web.socket.WebSocketMessage, WebSocketEndpointConfiguration> {
    public org.springframework.web.socket.WebSocketMessage convertOutbound(Message message, WebSocketEndpointConfiguration endpointConfiguration, TestContext context) {
        TextMessage webSocketMessage;
        WebSocketMessage internalMessage = message instanceof WebSocketMessage ? (WebSocketMessage)message : new WebSocketMessage(message);
        Object payload = internalMessage.getPayload();
        if (payload instanceof String) {
            webSocketMessage = new TextMessage((CharSequence)payload.toString(), internalMessage.isLast());
        } else if (payload instanceof ByteBuffer) {
            webSocketMessage = new BinaryMessage((ByteBuffer)payload, internalMessage.isLast());
        } else if (payload instanceof byte[]) {
            webSocketMessage = new BinaryMessage((byte[])payload, internalMessage.isLast());
        } else {
            try {
                webSocketMessage = new TextMessage((CharSequence)internalMessage.getPayload(String.class), internalMessage.isLast());
            }
            catch (ConversionNotSupportedException e) {
                throw new CitrusRuntimeException(String.format("Found unsupported payload type: '%s'", payload.getClass().getCanonicalName()), (Throwable)e);
            }
        }
        this.convertOutbound((org.springframework.web.socket.WebSocketMessage)webSocketMessage, (Message)internalMessage, endpointConfiguration, context);
        return webSocketMessage;
    }

    public void convertOutbound(org.springframework.web.socket.WebSocketMessage externalMessage, Message internalMessage, WebSocketEndpointConfiguration endpointConfiguration, TestContext context) {
    }

    public Message convertInbound(org.springframework.web.socket.WebSocketMessage externalMessage, WebSocketEndpointConfiguration endpointConfiguration, TestContext context) {
        return new WebSocketMessage(externalMessage.getPayload()).last(externalMessage.isLast());
    }
}

