/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.websocket.servlet;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.http.server.HttpServer;
import com.consol.citrus.http.servlet.CitrusDispatcherServlet;
import com.consol.citrus.websocket.endpoint.WebSocketEndpoint;
import com.consol.citrus.websocket.handler.CitrusWebSocketHandler;
import com.consol.citrus.websocket.handler.WebSocketUrlHandlerMapping;
import com.consol.citrus.websocket.interceptor.SessionEnricherHandshakeInterceptor;
import com.consol.citrus.websocket.server.WebSocketServer;
import java.util.HashMap;
import java.util.List;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;
import org.springframework.web.socket.server.support.WebSocketHttpRequestHandler;

public class CitrusWebSocketDispatcherServlet
extends CitrusDispatcherServlet {
    private WebSocketServer webSocketServer;
    protected static final String URL_HANDLER_MAPPING_BEAN_NAME = "citrusUrlHandlerMapping";
    private static final String HANDSHAKE_HANDLER_BEAN_NAME = "citrusHandshakeHandler";

    public CitrusWebSocketDispatcherServlet(WebSocketServer webSocketServer) {
        super((HttpServer)webSocketServer);
        this.webSocketServer = webSocketServer;
    }

    protected void initStrategies(ApplicationContext context) {
        super.initStrategies(context);
        this.configureWebSockerHandler(context);
    }

    private void configureWebSockerHandler(ApplicationContext context) {
        HashMap<String, Object> wsHandlers;
        WebSocketUrlHandlerMapping urlHandlerMapping;
        List<WebSocketEndpoint> webSocketEndpoints = this.webSocketServer.getWebSockets();
        if (CollectionUtils.isEmpty(webSocketEndpoints)) {
            return;
        }
        if (context.containsBean(URL_HANDLER_MAPPING_BEAN_NAME)) {
            urlHandlerMapping = (WebSocketUrlHandlerMapping)((Object)context.getBean(URL_HANDLER_MAPPING_BEAN_NAME, WebSocketUrlHandlerMapping.class));
            DefaultHandshakeHandler handshakeHandler = new DefaultHandshakeHandler();
            if (context.containsBean(HANDSHAKE_HANDLER_BEAN_NAME)) {
                handshakeHandler = (HandshakeHandler)context.getBean(HANDSHAKE_HANDLER_BEAN_NAME, HandshakeHandler.class);
            }
            wsHandlers = new HashMap<String, Object>();
            for (WebSocketEndpoint webSocketEndpoint : webSocketEndpoints) {
                String wsPath = webSocketEndpoint.getEndpointConfiguration().getEndpointUri();
                CitrusWebSocketHandler handler = new CitrusWebSocketHandler();
                webSocketEndpoint.setWebSocketHandler(handler);
                WebSocketHttpRequestHandler wsRequestHandler = new WebSocketHttpRequestHandler((WebSocketHandler)handler, (HandshakeHandler)handshakeHandler);
                SessionEnricherHandshakeInterceptor handshakeInterceptor = new SessionEnricherHandshakeInterceptor(webSocketEndpoint.getName(), wsPath);
                wsRequestHandler.getHandshakeInterceptors().add(handshakeInterceptor);
                wsHandlers.put(wsPath, wsRequestHandler);
            }
        } else {
            throw new CitrusRuntimeException(String.format("Invalid WebSocket configuration - missing bean. Expected to find bean with name '%s' in Spring application context", URL_HANDLER_MAPPING_BEAN_NAME));
        }
        urlHandlerMapping.setUrlMap(wsHandlers);
        urlHandlerMapping.postRegisterUrlHandlers(wsHandlers);
    }
}

