/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.websocket.client;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.websocket.endpoint.AbstractWebSocketEndpointConfiguration;
import com.consol.citrus.websocket.handler.CitrusWebSocketHandler;
import java.util.Collections;
import javax.websocket.Extension;
import org.eclipse.jetty.websocket.common.extensions.compress.PerMessageDeflateExtension;
import org.eclipse.jetty.websocket.jsr356.JsrExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.adapter.standard.StandardToWebSocketExtensionAdapter;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.util.UriComponentsBuilder;

public class WebSocketClientEndpointConfiguration
extends AbstractWebSocketEndpointConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketClientEndpointConfiguration.class);
    private CitrusWebSocketHandler handler;
    private WebSocketClient client = new StandardWebSocketClient();
    private WebSocketHttpHeaders webSocketHttpHeaders;

    @Override
    public CitrusWebSocketHandler getHandler() {
        if (this.handler == null) {
            this.handler = this.getWebSocketClientHandler(this.getEndpointUri());
        }
        return this.handler;
    }

    @Override
    public void setHandler(CitrusWebSocketHandler handler) {
        throw new UnsupportedOperationException("Not allowed to set web socket handler directly!");
    }

    private CitrusWebSocketHandler getWebSocketClientHandler(String url) {
        CitrusWebSocketHandler handler = new CitrusWebSocketHandler();
        if (this.webSocketHttpHeaders == null) {
            this.webSocketHttpHeaders = new WebSocketHttpHeaders();
            this.webSocketHttpHeaders.setSecWebSocketExtensions(Collections.singletonList(new StandardToWebSocketExtensionAdapter((Extension)new JsrExtension(new PerMessageDeflateExtension().getName()))));
        }
        ListenableFuture future = this.client.doHandshake((WebSocketHandler)handler, this.webSocketHttpHeaders, UriComponentsBuilder.fromUriString((String)url).buildAndExpand(new Object[0]).encode().toUri());
        try {
            future.get();
        }
        catch (Exception e) {
            String errMsg = String.format("Failed to connect to Web Socket server - '%s'", url);
            LOG.error(errMsg);
            throw new CitrusRuntimeException(errMsg);
        }
        return handler;
    }

    public void setClient(WebSocketClient client) {
        this.client = client;
    }

    public WebSocketHttpHeaders getWebSocketHttpHeaders() {
        return this.webSocketHttpHeaders;
    }

    public void setWebSocketHttpHeaders(WebSocketHttpHeaders webSocketHttpHeaders) {
        this.webSocketHttpHeaders = webSocketHttpHeaders;
    }
}

