/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.websocket.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AnnotationConfigParser;
import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.spi.ReferenceResolver;
import com.consol.citrus.websocket.client.WebSocketClient;
import com.consol.citrus.websocket.client.WebSocketClientBuilder;
import com.consol.citrus.websocket.config.annotation.WebSocketClientConfig;
import com.consol.citrus.websocket.message.WebSocketMessageConverter;
import org.springframework.util.StringUtils;

public class WebSocketClientConfigParser
implements AnnotationConfigParser<WebSocketClientConfig, WebSocketClient> {
    public WebSocketClient parse(WebSocketClientConfig annotation, ReferenceResolver referenceResolver) {
        WebSocketClientBuilder builder = new WebSocketClientBuilder();
        builder.requestUrl(annotation.requestUrl());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((WebSocketMessageConverter)referenceResolver.resolve(annotation.messageConverter(), WebSocketMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.endpointResolver())) {
            builder.endpointResolver((EndpointUriResolver)referenceResolver.resolve(annotation.endpointResolver(), EndpointUriResolver.class));
        }
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)referenceResolver.resolve(annotation.actor(), TestActor.class));
        }
        return (WebSocketClient)builder.initialize().build();
    }
}

