/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.websocket.config.xml;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.http.config.xml.HttpServerParser;
import com.consol.citrus.server.AbstractServer;
import com.consol.citrus.websocket.server.WebSocketServer;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class WebSocketServerParser
extends HttpServerParser {
    protected void parseServer(BeanDefinitionBuilder builder, Element element, ParserContext parserContext) {
        super.parseServer(builder, element, parserContext);
        ManagedList webSocketReferences = new ManagedList();
        Element socketsElement = DomUtils.getChildElementByTagName((Element)element, (String)"endpoints");
        if (socketsElement != null) {
            List socketElements = DomUtils.getChildElements((Element)socketsElement);
            if (CollectionUtils.isEmpty((Collection)socketElements)) {
                throw new CitrusRuntimeException("Invalid '<endpoints>..</endpoints>' configuration - at least one '<endpoint ref=\"..\" />' must be defined");
            }
            for (Element socketElement : socketElements) {
                if (!socketElement.hasAttribute("ref")) continue;
                webSocketReferences.add((Object)new RuntimeBeanReference(socketElement.getAttribute("ref")));
            }
            if (webSocketReferences.size() > 0) {
                builder.addPropertyValue("webSockets", (Object)webSocketReferences);
            }
        }
    }

    protected Class<? extends AbstractServer> getServerClass() {
        return WebSocketServer.class;
    }
}

