/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.endpoint.resolver.EndpointUriResolver;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.MessageCorrelator;
import com.consol.citrus.ws.client.WebServiceClient;
import com.consol.citrus.ws.client.WebServiceClientBuilder;
import com.consol.citrus.ws.config.annotation.WebServiceClientConfig;
import com.consol.citrus.ws.message.converter.WebServiceMessageConverter;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessageFactory;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.transport.WebServiceMessageSender;

public class WebServiceClientConfigParser
extends AbstractAnnotationConfigParser<WebServiceClientConfig, WebServiceClient> {
    public WebServiceClientConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    public WebServiceClient parse(WebServiceClientConfig annotation) {
        WebServiceClientBuilder builder = new WebServiceClientBuilder();
        builder.defaultUri(annotation.requestUrl());
        if (StringUtils.hasText((String)annotation.webServiceTemplate()) && (StringUtils.hasText((String)annotation.messageFactory()) || StringUtils.hasText((String)annotation.messageSender()))) {
            throw new CitrusRuntimeException("When providing a 'web-service-template' reference, none of 'message-factory', 'message-sender' should be set");
        }
        if (!StringUtils.hasText((String)annotation.requestUrl()) && !StringUtils.hasText((String)annotation.endpointResolver())) {
            throw new CitrusRuntimeException("One of the properties 'request-url' or 'endpoint-resolver' is required!");
        }
        if (StringUtils.hasText((String)annotation.webServiceTemplate())) {
            builder.webServiceTemplate((WebServiceTemplate)this.getReferenceResolver().resolve(annotation.webServiceTemplate(), WebServiceTemplate.class));
        }
        if (StringUtils.hasText((String)annotation.messageFactory())) {
            builder.messageFactory((WebServiceMessageFactory)this.getReferenceResolver().resolve(annotation.messageFactory(), WebServiceMessageFactory.class));
        } else {
            builder.messageFactory((WebServiceMessageFactory)this.getReferenceResolver().resolve("messageFactory", WebServiceMessageFactory.class));
        }
        if (StringUtils.hasText((String)annotation.messageSender())) {
            builder.messageSender((WebServiceMessageSender)this.getReferenceResolver().resolve(annotation.messageSender(), WebServiceMessageSender.class));
        }
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter((WebServiceMessageConverter)this.getReferenceResolver().resolve(annotation.messageConverter(), WebServiceMessageConverter.class));
        }
        builder.interceptors(this.getReferenceResolver().resolve(annotation.interceptors(), ClientInterceptor.class));
        if (StringUtils.hasText((String)annotation.interceptor())) {
            builder.interceptor((ClientInterceptor)this.getReferenceResolver().resolve(annotation.interceptor(), ClientInterceptor.class));
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator((MessageCorrelator)this.getReferenceResolver().resolve(annotation.correlator(), MessageCorrelator.class));
        }
        if (StringUtils.hasText((String)annotation.endpointResolver())) {
            builder.endpointResolver((EndpointUriResolver)this.getReferenceResolver().resolve(annotation.endpointResolver(), EndpointUriResolver.class));
        }
        builder.faultStrategy(annotation.faultStrategy());
        builder.pollingInterval(annotation.pollingInterval());
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor((TestActor)this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        return (WebServiceClient)builder.initialize().build();
    }
}

