/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.ReceiveMessageActionParser;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.ws.actions.ReceiveSoapMessageAction;
import com.consol.citrus.ws.config.xml.SoapAttachmentParser;
import com.consol.citrus.ws.message.SoapAttachment;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ReceiveSoapMessageActionParser
extends ReceiveMessageActionParser {
    protected BeanDefinitionBuilder parseComponent(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ReceiveSoapMessageAction.class);
        List attachmentElements = DomUtils.getChildElementsByTagName((Element)element, (String)"attachment");
        ArrayList<SoapAttachment> attachments = new ArrayList<SoapAttachment>();
        for (Element attachment : attachmentElements) {
            attachments.add(SoapAttachmentParser.parseAttachment(attachment));
        }
        builder.addPropertyValue("attachments", attachments);
        if (!attachments.isEmpty()) {
            BeanDefinitionParserUtils.setPropertyReference((BeanDefinitionBuilder)builder, (String)((Element)attachmentElements.get(0)).getAttribute("validator"), (String)"attachmentValidator", (String)"soapAttachmentValidator");
        }
        return builder;
    }

    protected void parseHeaderElements(Element actionElement, AbstractMessageContentBuilder messageBuilder, List<ValidationContext> validationContexts) {
        super.parseHeaderElements(actionElement, messageBuilder, validationContexts);
        if (actionElement.hasAttribute("soap-action")) {
            messageBuilder.getMessageHeaders().put("citrus_soap_action", actionElement.getAttribute("soap-action"));
        }
        if (actionElement.hasAttribute("content-type")) {
            messageBuilder.getMessageHeaders().put("citrus_http_Content-Type", actionElement.getAttribute("content-type"));
        }
        if (actionElement.hasAttribute("accept")) {
            messageBuilder.getMessageHeaders().put("citrus_http_Accept", actionElement.getAttribute("accept"));
        }
    }
}

