/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.interceptor;

import com.consol.citrus.ws.interceptor.LoggingInterceptorSupport;
import javax.xml.transform.TransformerException;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapEnvelopeException;

public class LoggingClientInterceptor
extends LoggingInterceptorSupport
implements ClientInterceptor {
    public boolean handleRequest(MessageContext messageContext) throws WebServiceClientException {
        try {
            this.logRequest("Sending SOAP request", messageContext, false);
        }
        catch (SoapEnvelopeException e) {
            this.log.warn("Unable to write SOAP request to logger", (Throwable)e);
        }
        catch (TransformerException e) {
            this.log.warn("Unable to write SOAP request to logger", (Throwable)e);
        }
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) throws WebServiceClientException {
        try {
            this.logResponse("Received SOAP response", messageContext, true);
        }
        catch (SoapEnvelopeException e) {
            this.log.warn("Unable to write SOAP response to logger", (Throwable)e);
        }
        catch (TransformerException e) {
            this.log.warn("Unable to write SOAP response to logger", (Throwable)e);
        }
        return true;
    }

    public boolean handleFault(MessageContext messageContext) throws WebServiceClientException {
        try {
            this.logResponse("Received SOAP fault", messageContext, true);
        }
        catch (SoapEnvelopeException e) {
            this.log.warn("Unable to write SOAP fault to logger", (Throwable)e);
        }
        catch (TransformerException e) {
            this.log.warn("Unable to write SOAP fault to logger", (Throwable)e);
        }
        return true;
    }

    public void afterCompletion(MessageContext messageContext, Exception ex) throws WebServiceClientException {
    }
}

