/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.message;

import com.consol.citrus.Citrus;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.mime.Attachment;

public class SoapAttachment
implements Attachment,
Serializable {
    private static final long serialVersionUID = 6277464458242523954L;
    public static final String ENCODING_BASE64_BINARY = "base64Binary";
    public static final String ENCODING_HEX_BINARY = "hexBinary";
    private String content = null;
    private String contentResourcePath;
    private String contentType = "text/plain";
    private String contentId = null;
    private String charsetName = "UTF-8";
    private boolean mtomInline = false;
    private DataHandler dataHandler = null;
    private String encodingType = "base64Binary";
    private TestContext context;

    public SoapAttachment() {
    }

    public static SoapAttachment from(Attachment attachment) {
        SoapAttachment soapAttachment = new SoapAttachment();
        String contentId = attachment.getContentId();
        if (contentId.startsWith("<") && contentId.endsWith(">")) {
            contentId = contentId.substring(1, contentId.length() - 1);
        }
        soapAttachment.setContentId(contentId);
        soapAttachment.setContentType(attachment.getContentType());
        if (attachment.getContentType().startsWith("text")) {
            try {
                soapAttachment.setContent(FileUtils.readToString((InputStream)attachment.getInputStream()).trim());
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read SOAP attachment content", (Throwable)e);
            }
        } else {
            soapAttachment.setDataHandler(attachment.getDataHandler());
        }
        soapAttachment.setCharsetName(Citrus.CITRUS_FILE_ENCODING);
        return soapAttachment;
    }

    public SoapAttachment(String content) {
        this.content = content;
    }

    public String getContentId() {
        if (this.contentId != null && this.context != null) {
            return this.context.replaceDynamicContentInString(this.contentId);
        }
        return this.contentId;
    }

    public String getContentType() {
        if (this.contentType != null && this.context != null) {
            return this.context.replaceDynamicContentInString(this.contentType);
        }
        return this.contentType;
    }

    public DataHandler getDataHandler() {
        if (this.dataHandler == null) {
            this.dataHandler = StringUtils.hasText((String)this.getContentResourcePath()) ? new DataHandler((DataSource)new FileResourceDataSource()) : new DataHandler((DataSource)new ContentDataSource());
        }
        return this.dataHandler;
    }

    public void setDataHandler(DataHandler dataHandler) {
        this.dataHandler = dataHandler;
    }

    public InputStream getInputStream() throws IOException {
        return this.getDataHandler().getInputStream();
    }

    public long getSize() {
        try {
            if (this.content != null) {
                return this.getContent().getBytes(this.charsetName).length;
            }
            return SoapAttachment.getSizeOfContent(this.getDataHandler().getInputStream());
        }
        catch (UnsupportedEncodingException e) {
            throw new CitrusRuntimeException((Throwable)e);
        }
        catch (IOException ioe) {
            throw new CitrusRuntimeException((Throwable)ioe);
        }
    }

    public String toString() {
        return String.format("%s [contentId: %s, contentType: %s, content: %s]", this.getClass().getSimpleName().toUpperCase(), this.getContentId(), this.getContentType(), this.getContent());
    }

    public String getContent() {
        if (this.content != null) {
            return this.context != null ? this.context.replaceDynamicContentInString(this.content) : this.content;
        }
        if (StringUtils.hasText((String)this.getContentResourcePath()) && this.getContentType().startsWith("text")) {
            try {
                String fileContent = FileUtils.readToString((InputStream)new PathMatchingResourcePatternResolver().getResource(this.getContentResourcePath()).getInputStream(), (Charset)Charset.forName(this.charsetName));
                return this.context != null ? this.context.replaceDynamicContentInString(fileContent) : fileContent;
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to read SOAP attachment file resource", (Throwable)e);
            }
        }
        try {
            byte[] binaryData = FileCopyUtils.copyToByteArray((InputStream)this.getDataHandler().getInputStream());
            if (this.encodingType.equals(ENCODING_BASE64_BINARY)) {
                return Base64.encodeBase64String((byte[])binaryData);
            }
            if (this.encodingType.equals(ENCODING_HEX_BINARY)) {
                return Hex.encodeHexString((byte[])binaryData).toUpperCase();
            }
            throw new CitrusRuntimeException(String.format("Unsupported encoding type '%s' for SOAP attachment - choose one of %s or %s", this.encodingType, ENCODING_BASE64_BINARY, ENCODING_HEX_BINARY));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read SOAP attachment data input stream", (Throwable)e);
        }
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentResourcePath() {
        if (this.contentResourcePath != null && this.context != null) {
            return this.context.replaceDynamicContentInString(this.contentResourcePath);
        }
        return this.contentResourcePath;
    }

    public void setContentResourcePath(String path) {
        this.contentResourcePath = path;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public void setMtomInline(boolean inline) {
        this.mtomInline = inline;
    }

    public boolean isMtomInline() {
        return this.mtomInline;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public void setTestContext(TestContext context) {
        this.context = context;
    }

    private static long getSizeOfContent(InputStream is) throws IOException {
        long size = 0L;
        while (is.read() != -1) {
            ++size;
        }
        return size;
    }

    private class FileResourceDataSource
    implements DataSource {
        private FileResourceDataSource() {
        }

        public InputStream getInputStream() throws IOException {
            return this.getFileResource().getInputStream();
        }

        public String getContentType() {
            return SoapAttachment.this.getContentType();
        }

        public String getName() {
            return this.getFileResource().getFilename();
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        private Resource getFileResource() {
            return new PathMatchingResourcePatternResolver().getResource(SoapAttachment.this.getContentResourcePath());
        }
    }

    private class ContentDataSource
    implements DataSource {
        private ContentDataSource() {
        }

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(SoapAttachment.this.getContent().getBytes(SoapAttachment.this.charsetName));
        }

        public String getContentType() {
            return SoapAttachment.this.getContentType();
        }

        public String getName() {
            return SoapAttachment.this.getContentId();
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

