/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.security;

import com.consol.citrus.ws.security.User;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.eclipse.jetty.security.AbstractLoginService;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class SecurityHandlerFactory
implements InitializingBean,
FactoryBean<SecurityHandler> {
    private List<User> users = new ArrayList<User>();
    private String realm = "realm";
    private Map<String, Constraint> constraints = new HashMap<String, Constraint>();
    private LoginService loginService;
    private Authenticator authenticator = new BasicAuthenticator();

    public SecurityHandler getObject() throws Exception {
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setAuthenticator(this.authenticator);
        securityHandler.setRealmName(this.realm);
        for (Map.Entry<String, Constraint> constraint : this.constraints.entrySet()) {
            ConstraintMapping constraintMapping = new ConstraintMapping();
            constraintMapping.setConstraint(constraint.getValue());
            constraintMapping.setPathSpec(constraint.getKey());
            securityHandler.addConstraintMapping(constraintMapping);
        }
        securityHandler.setLoginService(this.loginService);
        return securityHandler;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.loginService == null) {
            this.loginService = new SimpleLoginService();
            ((SimpleLoginService)this.loginService).setName(this.realm);
        }
    }

    public Class<?> getObjectType() {
        return SecurityHandler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public List<User> getUsers() {
        return this.users;
    }

    public void setUsers(List<User> users) {
        this.users = users;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public Map<String, Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(Map<String, Constraint> constraints) {
        this.constraints = constraints;
    }

    public LoginService getLoginService() {
        return this.loginService;
    }

    public void setLoginService(LoginService loginService) {
        this.loginService = loginService;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    private class SimplePropertyUserStore
    extends PropertyUserStore {
        private SimplePropertyUserStore() {
        }

        protected void loadUsers() throws IOException {
            for (User user : SecurityHandlerFactory.this.users) {
                Credential credential = Credential.getCredential((String)user.getPassword());
                AbstractLoginService.UserPrincipal userPrincipal = new AbstractLoginService.UserPrincipal(user.getName(), credential);
                Subject subject = new Subject();
                subject.getPrincipals().add((Principal)userPrincipal);
                subject.getPrivateCredentials().add(credential);
                String[] roleArray = IdentityService.NO_ROLES;
                if (user.getRoles() != null && user.getRoles().length > 0) {
                    roleArray = user.getRoles();
                }
                for (String role : roleArray) {
                    subject.getPrincipals().add((Principal)new AbstractLoginService.RolePrincipal(role));
                }
                subject.setReadOnly();
                this.getKnownUserIdentities().put(user.getName(), this.getIdentityService().newUserIdentity(subject, (Principal)userPrincipal, roleArray));
            }
        }
    }

    private class SimpleLoginService
    extends HashLoginService {
        private SimpleLoginService() {
        }

        protected void doStart() throws Exception {
            SimplePropertyUserStore userStore = new SimplePropertyUserStore();
            this.setUserStore((UserStore)userStore);
            userStore.start();
            super.doStart();
        }
    }
}

