/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.server;

import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.adapter.EmptyResponseEndpointAdapter;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageHeaderUtils;
import com.consol.citrus.ws.client.WebServiceEndpointConfiguration;
import com.consol.citrus.ws.message.SoapAttachment;
import com.consol.citrus.ws.message.SoapFault;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.MimeHeaders;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.mime.MimeMessage;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.SoapBody;
import org.springframework.ws.soap.SoapFaultDetail;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.axiom.AxiomSoapMessage;
import org.springframework.ws.soap.saaj.SaajSoapMessage;
import org.springframework.ws.soap.server.endpoint.SoapFaultDefinition;
import org.springframework.ws.soap.soap11.Soap11Body;
import org.springframework.ws.soap.soap12.Soap12Body;
import org.springframework.ws.soap.soap12.Soap12Fault;
import org.springframework.ws.transport.WebServiceConnection;
import org.springframework.ws.transport.context.TransportContextHolder;
import org.springframework.ws.transport.http.HttpServletConnection;
import org.springframework.xml.namespace.QNameUtils;
import org.springframework.xml.transform.StringSource;
import org.w3c.dom.Document;

public class WebServiceEndpoint
implements MessageEndpoint {
    private EndpointAdapter endpointAdapter = new EmptyResponseEndpointAdapter();
    private String defaultNamespaceUri;
    private String defaultPrefix = "";
    private WebServiceEndpointConfiguration endpointConfiguration = new WebServiceEndpointConfiguration();
    private static Logger log = LoggerFactory.getLogger(WebServiceEndpoint.class);
    private static final String DEFAULT_JMS_HEADER_PREFIX = "JMS";

    public void invoke(MessageContext messageContext) throws Exception {
        Message replyMessage;
        Assert.notNull((Object)messageContext.getRequest(), (String)"Request must not be null - unable to send message");
        Message requestMessage = this.endpointConfiguration.getMessageConverter().convertInbound(messageContext.getRequest(), messageContext, this.endpointConfiguration);
        if (log.isDebugEnabled()) {
            log.debug("Received SOAP request:\n" + requestMessage.toString());
        }
        if (this.simulateHttpStatusCode(replyMessage = this.endpointAdapter.handleMessage(requestMessage))) {
            return;
        }
        if (replyMessage != null && replyMessage.getPayload() != null) {
            if (log.isDebugEnabled()) {
                log.debug("Sending SOAP response:\n" + replyMessage.toString());
            }
            SoapMessage response = (SoapMessage)messageContext.getResponse();
            if (replyMessage instanceof SoapFault) {
                this.addSoapFault(response, (SoapFault)replyMessage);
            } else {
                this.addSoapBody(response, replyMessage);
            }
            this.addSoapAttachments((MimeMessage)response, replyMessage);
            this.addSoapHeaders(response, replyMessage);
            this.addMimeHeaders(response, replyMessage);
        } else {
            if (log.isDebugEnabled()) {
                log.debug("No reply message from endpoint adapter '" + this.endpointAdapter + "'");
            }
            log.warn("No SOAP response for calling client");
        }
    }

    private void addSoapAttachments(MimeMessage response, Message replyMessage) {
        if (replyMessage instanceof com.consol.citrus.ws.message.SoapMessage) {
            List<SoapAttachment> soapAttachments = ((com.consol.citrus.ws.message.SoapMessage)replyMessage).getAttachments();
            soapAttachments.stream().filter(soapAttachment -> !soapAttachment.isMtomInline()).forEach(soapAttachment -> {
                String contentId = soapAttachment.getContentId();
                if (!contentId.startsWith("<")) {
                    contentId = "<" + contentId + ">";
                }
                response.addAttachment(contentId, soapAttachment.getDataHandler());
            });
        }
    }

    private boolean simulateHttpStatusCode(Message replyMessage) throws IOException {
        if (replyMessage == null || CollectionUtils.isEmpty((Map)replyMessage.getHeaders())) {
            return false;
        }
        for (Map.Entry headerEntry : replyMessage.getHeaders().entrySet()) {
            if (!((String)headerEntry.getKey()).equalsIgnoreCase("citrus_http_status_code")) continue;
            WebServiceConnection connection = TransportContextHolder.getTransportContext().getConnection();
            int statusCode = Integer.valueOf(headerEntry.getValue().toString());
            if (connection instanceof HttpServletConnection) {
                ((HttpServletConnection)connection).setFault(false);
                ((HttpServletConnection)connection).getHttpServletResponse().setStatus(statusCode);
                return true;
            }
            log.warn("Unable to set custom Http status code on connection other than HttpServletConnection (" + connection.getClass().getName() + ")");
        }
        return false;
    }

    private void addMimeHeaders(SoapMessage response, Message replyMessage) {
        for (Map.Entry headerEntry : replyMessage.getHeaders().entrySet()) {
            if (!((String)headerEntry.getKey()).toLowerCase().startsWith("citrus_http_")) continue;
            String headerName = ((String)headerEntry.getKey()).substring("citrus_http_".length());
            if (response instanceof SaajSoapMessage) {
                SaajSoapMessage saajSoapMessage = (SaajSoapMessage)response;
                MimeHeaders headers = saajSoapMessage.getSaajMessage().getMimeHeaders();
                headers.setHeader(headerName, headerEntry.getValue().toString());
                continue;
            }
            if (response instanceof AxiomSoapMessage) {
                log.warn("Unable to set mime message header '" + headerName + "' on AxiomSoapMessage - unsupported");
                continue;
            }
            log.warn("Unsupported SOAP message implementation - unable to set mime message header '" + headerName + "'");
        }
    }

    private void addSoapBody(SoapMessage response, Message replyMessage) throws TransformerException {
        if (!(replyMessage.getPayload() instanceof String) || StringUtils.hasText((String)((String)replyMessage.getPayload(String.class)))) {
            Source responseSource = this.getPayloadAsSource(replyMessage.getPayload());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(responseSource, response.getPayloadResult());
        }
    }

    private void addSoapHeaders(SoapMessage response, Message replyMessage) throws TransformerException {
        for (Map.Entry headerEntry : replyMessage.getHeaders().entrySet()) {
            SoapHeaderElement headerElement;
            if (MessageHeaderUtils.isSpringInternalHeader((String)((String)headerEntry.getKey())) || ((String)headerEntry.getKey()).startsWith(DEFAULT_JMS_HEADER_PREFIX)) continue;
            if (((String)headerEntry.getKey()).equalsIgnoreCase("citrus_soap_action")) {
                response.setSoapAction(headerEntry.getValue().toString());
                continue;
            }
            if (((String)headerEntry.getKey()).startsWith("citrus_")) continue;
            if (QNameUtils.validateQName((String)((String)headerEntry.getKey()))) {
                QName qname = QNameUtils.parseQNameString((String)((String)headerEntry.getKey()));
                headerElement = StringUtils.hasText((String)qname.getNamespaceURI()) ? response.getSoapHeader().addHeaderElement(qname) : response.getSoapHeader().addHeaderElement(this.getDefaultQName((String)headerEntry.getKey()));
            } else {
                throw new SoapHeaderException("Failed to add SOAP header '" + (String)headerEntry.getKey() + "', because of invalid QName");
            }
            headerElement.setText(headerEntry.getValue().toString());
        }
        for (String headerData : replyMessage.getHeaderData()) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform((Source)new StringSource(headerData), response.getSoapHeader().getResult());
        }
    }

    private void addSoapFault(SoapMessage response, SoapFault replyMessage) throws TransformerException {
        List<String> soapFaultDetails;
        org.springframework.ws.soap.SoapFault soapFault;
        SoapBody soapBody = response.getSoapBody();
        if (SoapFaultDefinition.SERVER.equals(replyMessage.getFaultCodeQName()) || SoapFaultDefinition.RECEIVER.equals(replyMessage.getFaultCodeQName())) {
            soapFault = soapBody.addServerOrReceiverFault(replyMessage.getFaultString(), replyMessage.getLocale());
        } else if (SoapFaultDefinition.CLIENT.equals(replyMessage.getFaultCodeQName()) || SoapFaultDefinition.SENDER.equals(replyMessage.getFaultCodeQName())) {
            soapFault = soapBody.addClientOrSenderFault(replyMessage.getFaultString(), replyMessage.getLocale());
        } else if (soapBody instanceof Soap11Body) {
            Soap11Body soap11Body = (Soap11Body)soapBody;
            soapFault = soap11Body.addFault(replyMessage.getFaultCodeQName(), replyMessage.getFaultString(), replyMessage.getLocale());
        } else if (soapBody instanceof Soap12Body) {
            Soap12Body soap12Body = (Soap12Body)soapBody;
            Soap12Fault soap12Fault = soap12Body.addServerOrReceiverFault(replyMessage.getFaultString(), replyMessage.getLocale());
            soap12Fault.addFaultSubcode(replyMessage.getFaultCodeQName());
            soapFault = soap12Fault;
        } else {
            throw new CitrusRuntimeException("Found unsupported SOAP implementation. Use SOAP 1.1 or SOAP 1.2.");
        }
        if (replyMessage.getFaultActor() != null) {
            soapFault.setFaultActorOrRole(replyMessage.getFaultActor());
        }
        if (!(soapFaultDetails = replyMessage.getFaultDetails()).isEmpty()) {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            SoapFaultDetail faultDetail = soapFault.addFaultDetail();
            for (int i = 0; i < soapFaultDetails.size(); ++i) {
                transformer.transform((Source)new StringSource(soapFaultDetails.get(i)), faultDetail.getResult());
            }
        }
    }

    private Source getPayloadAsSource(Object replyPayload) {
        if (replyPayload instanceof Source) {
            return (Source)replyPayload;
        }
        if (replyPayload instanceof Document) {
            return new DOMSource((Document)replyPayload);
        }
        if (replyPayload instanceof String) {
            return new StringSource((String)replyPayload);
        }
        throw new CitrusRuntimeException("Unknown type for reply message payload (" + replyPayload.getClass().getName() + ") Supported types are '" + Source.class.getName() + "', '" + Document.class.getName() + "', or '" + String.class.getName() + "'");
    }

    private QName getDefaultQName(String localPart) {
        if (StringUtils.hasText((String)this.defaultNamespaceUri)) {
            return new QName(this.defaultNamespaceUri, localPart, this.defaultPrefix);
        }
        throw new SoapHeaderException("Failed to add SOAP header '" + localPart + "', because neither valid QName nor default namespace-uri is set!");
    }

    public EndpointAdapter getEndpointAdapter() {
        return this.endpointAdapter;
    }

    public void setEndpointAdapter(EndpointAdapter endpointAdapter) {
        this.endpointAdapter = endpointAdapter;
    }

    public String getDefaultNamespaceUri() {
        return this.defaultNamespaceUri;
    }

    public void setDefaultNamespaceUri(String defaultNamespaceUri) {
        this.defaultNamespaceUri = defaultNamespaceUri;
    }

    public String getDefaultPrefix() {
        return this.defaultPrefix;
    }

    public void setDefaultPrefix(String defaultPrefix) {
        this.defaultPrefix = defaultPrefix;
    }

    public WebServiceEndpointConfiguration getEndpointConfiguration() {
        return this.endpointConfiguration;
    }

    public void setEndpointConfiguration(WebServiceEndpointConfiguration endpointConfiguration) {
        this.endpointConfiguration = endpointConfiguration;
    }
}

