/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.server;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.server.AbstractServer;
import com.consol.citrus.ws.message.converter.SoapMessageConverter;
import com.consol.citrus.ws.message.converter.WebServiceMessageConverter;
import com.consol.citrus.ws.servlet.CitrusMessageDispatcherServlet;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;

public class WebServiceServer
extends AbstractServer
implements ApplicationContextAware {
    private int port = 8080;
    private String resourceBase = "src/main/resources";
    private String contextConfigLocation = "classpath:com/consol/citrus/ws/citrus-servlet-context.xml";
    private Server jettyServer;
    private ApplicationContext applicationContext;
    private boolean useRootContextAsParent = false;
    private static Object serverLock = new Object();
    private Connector connector;
    private Connector[] connectors;
    private String servletMappingPath = "/*";
    private String servletName;
    private String contextPath = "/";
    private SecurityHandler securityHandler;
    private ServletHandler servletHandler;
    private boolean handleMimeHeaders = false;
    private boolean handleAttributeHeaders = false;
    private boolean keepSoapEnvelope = false;
    private WebServiceMessageConverter messageConverter = new SoapMessageConverter();
    private String messageFactoryName = "messageFactory";
    private String soapHeaderNamespace;
    private String soapHeaderPrefix = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown() {
        if (this.jettyServer != null) {
            try {
                Object object = serverLock;
                synchronized (object) {
                    this.jettyServer.stop();
                }
            }
            catch (Exception e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        Object object = serverLock;
        synchronized (object) {
            if (this.connectors != null && this.connectors.length > 0) {
                this.jettyServer = this.connectors[0].getServer();
                this.jettyServer.setConnectors(this.connectors);
            } else if (this.connector != null) {
                this.jettyServer = this.connector.getServer();
                this.jettyServer.addConnector(this.connector);
            } else {
                this.jettyServer = new Server(this.port);
            }
            HandlerCollection handlers = new HandlerCollection();
            ContextHandlerCollection contextCollection = new ContextHandlerCollection();
            ServletContextHandler contextHandler = new ServletContextHandler();
            contextHandler.setContextPath(this.contextPath);
            contextHandler.setResourceBase(this.resourceBase);
            if (this.useRootContextAsParent) {
                contextHandler.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)new SimpleDelegatingWebApplicationContext());
            }
            if (this.servletHandler == null) {
                this.servletHandler = new ServletHandler();
                this.addDispatcherServlet();
            }
            contextHandler.setServletHandler(this.servletHandler);
            if (this.securityHandler != null) {
                contextHandler.setSecurityHandler(this.securityHandler);
            }
            contextCollection.addHandler((Handler)contextHandler);
            handlers.addHandler((Handler)contextCollection);
            handlers.addHandler((Handler)new DefaultHandler());
            handlers.addHandler((Handler)new RequestLogHandler());
            this.jettyServer.setHandler((Handler)handlers);
            try {
                this.jettyServer.start();
            }
            catch (Exception e) {
                throw new CitrusRuntimeException((Throwable)e);
            }
        }
    }

    private void addDispatcherServlet() {
        ServletHolder servletHolder = new ServletHolder((Servlet)new CitrusMessageDispatcherServlet(this));
        servletHolder.setName(this.getServletName());
        servletHolder.setInitParameter("contextConfigLocation", this.contextConfigLocation);
        this.servletHandler.addServlet(servletHolder);
        ServletMapping servletMapping = new ServletMapping();
        servletMapping.setServletName(this.getServletName());
        servletMapping.setPathSpec(this.servletMappingPath);
        this.servletHandler.addServletMapping(servletMapping);
    }

    public String getServletName() {
        if (StringUtils.hasText((String)this.servletName)) {
            return this.servletName;
        }
        return this.getName() + "-servlet";
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public String getContextConfigLocation() {
        return this.contextConfigLocation;
    }

    public void setContextConfigLocation(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    public Connector[] getConnectors() {
        if (this.connectors != null) {
            return Arrays.copyOf(this.connectors, this.connectors.length);
        }
        return new Connector[0];
    }

    public void setConnectors(Connector[] connectors) {
        this.connectors = Arrays.copyOf(connectors, connectors.length);
    }

    public String getServletMappingPath() {
        return this.servletMappingPath;
    }

    public void setServletMappingPath(String servletMappingPath) {
        this.servletMappingPath = servletMappingPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public void setSecurityHandler(SecurityHandler securityHandler) {
        this.securityHandler = securityHandler;
    }

    public ServletHandler getServletHandler() {
        return this.servletHandler;
    }

    public void setServletHandler(ServletHandler servletHandler) {
        this.servletHandler = servletHandler;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public boolean isUseRootContextAsParent() {
        return this.useRootContextAsParent;
    }

    public void setUseRootContextAsParent(boolean useRootContextAsParent) {
        this.useRootContextAsParent = useRootContextAsParent;
    }

    public boolean isHandleMimeHeaders() {
        return this.handleMimeHeaders;
    }

    public void setHandleMimeHeaders(boolean handleMimeHeaders) {
        this.handleMimeHeaders = handleMimeHeaders;
    }

    public boolean isHandleAttributeHeaders() {
        return this.handleAttributeHeaders;
    }

    public void setHandleAttributeHeaders(boolean handleAttributeHeaders) {
        this.handleAttributeHeaders = handleAttributeHeaders;
    }

    public boolean isKeepSoapEnvelope() {
        return this.keepSoapEnvelope;
    }

    public void setKeepSoapEnvelope(boolean keepSoapEnvelope) {
        this.keepSoapEnvelope = keepSoapEnvelope;
    }

    public String getSoapHeaderNamespace() {
        return this.soapHeaderNamespace;
    }

    public void setSoapHeaderNamespace(String soapHeaderNamespace) {
        this.soapHeaderNamespace = soapHeaderNamespace;
    }

    public String getSoapHeaderPrefix() {
        return this.soapHeaderPrefix;
    }

    public void setSoapHeaderPrefix(String soapHeaderPrefix) {
        this.soapHeaderPrefix = soapHeaderPrefix;
    }

    public WebServiceMessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setMessageConverter(WebServiceMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public String getMessageFactoryName() {
        return this.messageFactoryName;
    }

    public void setMessageFactoryName(String messageFactoryName) {
        this.messageFactoryName = messageFactoryName;
    }

    private final class SimpleDelegatingWebApplicationContext
    implements WebApplicationContext {
        private SimpleDelegatingWebApplicationContext() {
        }

        public Resource getResource(String location) {
            return WebServiceServer.this.applicationContext.getResource(location);
        }

        public ClassLoader getClassLoader() {
            return WebServiceServer.this.applicationContext.getClassLoader();
        }

        public Resource[] getResources(String locationPattern) throws IOException {
            return WebServiceServer.this.applicationContext.getResources(locationPattern);
        }

        public void publishEvent(ApplicationEvent event) {
            WebServiceServer.this.applicationContext.publishEvent(event);
        }

        public void publishEvent(Object event) {
            WebServiceServer.this.applicationContext.publishEvent(event);
        }

        public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
            return WebServiceServer.this.applicationContext.getMessage(code, args, defaultMessage, locale);
        }

        public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
            return WebServiceServer.this.applicationContext.getMessage(code, args, locale);
        }

        public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
            return WebServiceServer.this.applicationContext.getMessage(resolvable, locale);
        }

        public BeanFactory getParentBeanFactory() {
            return WebServiceServer.this.applicationContext.getParentBeanFactory();
        }

        public boolean containsLocalBean(String name) {
            return WebServiceServer.this.applicationContext.containsBean(name);
        }

        public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
            return WebServiceServer.this.applicationContext.isSingleton(name);
        }

        public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
            return WebServiceServer.this.applicationContext.isPrototype(name);
        }

        public Object getBean(String name) throws BeansException {
            return WebServiceServer.this.applicationContext.getBean(name);
        }

        public String[] getAliases(String name) {
            return WebServiceServer.this.applicationContext.getAliases(name);
        }

        public boolean containsBean(String name) {
            return WebServiceServer.this.applicationContext.containsBean(name);
        }

        public String[] getBeanDefinitionNames() {
            return WebServiceServer.this.applicationContext.getBeanDefinitionNames();
        }

        public String[] getBeanNamesForType(ResolvableType type) {
            return WebServiceServer.this.applicationContext.getBeanNamesForType(type);
        }

        public int getBeanDefinitionCount() {
            return WebServiceServer.this.applicationContext.getBeanDefinitionCount();
        }

        public boolean containsBeanDefinition(String beanName) {
            return WebServiceServer.this.applicationContext.containsBeanDefinition(beanName);
        }

        public long getStartupDate() {
            return WebServiceServer.this.applicationContext.getStartupDate();
        }

        public ApplicationContext getParent() {
            return WebServiceServer.this.applicationContext.getParent();
        }

        public String getId() {
            return WebServiceServer.this.applicationContext.getId();
        }

        public String getApplicationName() {
            return WebServiceServer.this.applicationContext.getApplicationName();
        }

        public String getDisplayName() {
            return WebServiceServer.this.applicationContext.getDisplayName();
        }

        public AutowireCapableBeanFactory getAutowireCapableBeanFactory() throws IllegalStateException {
            return WebServiceServer.this.applicationContext.getAutowireCapableBeanFactory();
        }

        public <T> Map<String, T> getBeansOfType(Class<T> type) throws BeansException {
            return WebServiceServer.this.applicationContext.getBeansOfType(type);
        }

        public <T> Map<String, T> getBeansOfType(Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
            return WebServiceServer.this.applicationContext.getBeansOfType(type, includeNonSingletons, allowEagerInit);
        }

        public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
            return WebServiceServer.this.applicationContext.getBeanNamesForAnnotation(annotationType);
        }

        public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
            return WebServiceServer.this.applicationContext.getBeansWithAnnotation(annotationType);
        }

        public <A extends Annotation> A findAnnotationOnBean(String beanName, Class<A> annotationType) {
            return (A)WebServiceServer.this.applicationContext.findAnnotationOnBean(beanName, annotationType);
        }

        public <T> T getBean(String name, Class<T> requiredType) throws BeansException {
            return (T)WebServiceServer.this.applicationContext.getBean(name, requiredType);
        }

        public <T> T getBean(Class<T> requiredType) throws BeansException {
            return (T)WebServiceServer.this.applicationContext.getBean(requiredType);
        }

        public String[] getBeanNamesForType(Class<?> type) {
            return WebServiceServer.this.applicationContext.getBeanNamesForType(type);
        }

        public String[] getBeanNamesForType(Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
            return WebServiceServer.this.applicationContext.getBeanNamesForType(type, includeNonSingletons, allowEagerInit);
        }

        public Object getBean(String name, Object ... args) throws BeansException {
            return WebServiceServer.this.applicationContext.getBean(name, args);
        }

        public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
            return (T)WebServiceServer.this.applicationContext.getBean(requiredType, args);
        }

        public boolean isTypeMatch(String name, Class<?> targetType) throws NoSuchBeanDefinitionException {
            return WebServiceServer.this.applicationContext.isTypeMatch(name, targetType);
        }

        public boolean isTypeMatch(String name, ResolvableType targetType) throws NoSuchBeanDefinitionException {
            return WebServiceServer.this.applicationContext.isTypeMatch(name, targetType);
        }

        public Class<?> getType(String name) throws NoSuchBeanDefinitionException {
            return WebServiceServer.this.applicationContext.getType(name);
        }

        public ServletContext getServletContext() {
            return null;
        }

        public Environment getEnvironment() {
            return WebServiceServer.this.applicationContext.getEnvironment();
        }
    }
}

