/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.ws.message.SoapFault;
import com.consol.citrus.ws.validation.AbstractSoapFaultValidator;
import com.consol.citrus.ws.validation.SoapFaultDetailValidationContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractFaultDetailValidator
extends AbstractSoapFaultValidator {
    private static Logger log = LoggerFactory.getLogger(AbstractFaultDetailValidator.class);

    @Override
    protected void validateFaultDetail(SoapFault receivedDetail, SoapFault controlDetail, TestContext context, ValidationContext validationContext) {
        if (controlDetail == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validating SOAP fault detail content ...");
        }
        if (receivedDetail == null) {
            throw new ValidationException("Missing SOAP fault detail in received message");
        }
        ArrayList<ValidationContext> contexts = new ArrayList<ValidationContext>();
        if (validationContext instanceof SoapFaultDetailValidationContext) {
            contexts.addAll(((SoapFaultDetailValidationContext)validationContext).getValidationContexts());
        }
        List<String> receivedDetailElements = receivedDetail.getFaultDetails();
        List<String> controlDetailElements = controlDetail.getFaultDetails();
        if (controlDetailElements.size() > receivedDetailElements.size()) {
            throw new ValidationException("Missing SOAP fault detail entry in received message");
        }
        for (int i = 0; i < controlDetailElements.size(); ++i) {
            String receivedDetailString = receivedDetailElements.get(i);
            String controlDetailString = controlDetailElements.get(i);
            this.validateFaultDetailString(XMLUtils.omitXmlDeclaration((String)receivedDetailString), XMLUtils.omitXmlDeclaration((String)controlDetailString), context, CollectionUtils.isEmpty(contexts) ? validationContext : (ValidationContext)contexts.get(i++));
        }
    }

    protected abstract void validateFaultDetailString(String var1, String var2, TestContext var3, ValidationContext var4) throws ValidationException;
}

