/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.ws.validation;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.ws.validation.AbstractFaultDetailValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class SimpleSoapFaultValidator
extends AbstractFaultDetailValidator {
    private static Logger log = LoggerFactory.getLogger(SimpleSoapFaultValidator.class);

    @Override
    protected void validateFaultDetailString(String received, String control, TestContext context, ValidationContext validationContext) throws ValidationException {
        log.debug("Validating SOAP fault detail ...");
        String receivedDetail = StringUtils.trimAllWhitespace((String)received);
        String controlDetail = StringUtils.trimAllWhitespace((String)control);
        if (log.isDebugEnabled()) {
            log.debug("Received fault detail:\n" + StringUtils.trimWhitespace((String)received));
            log.debug("Control fault detail:\n" + StringUtils.trimWhitespace((String)control));
        }
        if (!receivedDetail.equals(controlDetail)) {
            throw new ValidationException("SOAP fault validation failed! Fault detail does not match: expected \n'" + controlDetail + "' \n received \n'" + receivedDetail + "'");
        }
        log.info("SOAP fault detail validation successful: All values OK");
    }
}

